import { Space, Button, Select, Collapse } from "antd";
import styles from "../../index.module.scss";
import api, { FilterOptionResp } from "../../api";
import { useEffect, useState } from "react";

type Props = {
  onChange: (id: FilterOptionResp) => void;
};

export default function BrandItem(props: Props) {
  const [data, setData] = useState<FilterOptionResp[]>([]);

  useEffect(() => {
    api.brand().then((res) => {
      setData(res?.result || []);
    });
  }, []);

  const onClick = (item: FilterOptionResp) => {
    props.onChange({
      id: item.id,
      name: "品牌：" + item.name,
    });
  };

  return (
    <div className={styles.filterItem}>
      <div className={styles.filterItemTitle}>品牌：</div>
      <div className={`${styles.filterItemMain} ${data.length <= 10 && styles.disabled}`}>
        <Collapse
          ghost
          collapsible="icon"
          expandIconPosition="end"
          
        >
          <Collapse.Panel
            header={
              <Space size={40}>
                {data.slice(0, 10).map((item) => {
                  return (
                    <Button
                      type="link"
                      key={item.id}
                      onClick={(e) => onClick(item)}
                    >
                      {item.name}
                    </Button>
                  );
                })}
              </Space>
            }
            key="1"
          >
            <Space size={40}>
              {data.slice(10).map((item) => {
                return (
                  <Button
                    type="link"
                    key={item.id}
                    onClick={(e) => onClick(item)}
                  >
                    {item.name}
                  </Button>
                );
              })}
            </Space>
          </Collapse.Panel>
        </Collapse>
      </div>
    </div>
  );
}
