import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { HomeAPI } from '@/api';

const HomeNewsView = () => {
  // 路由钩子
  const router = useRouter();
  // tab栏索引
  const [currentIndex, setCurrentIndex] = useState<number>(0);
  // tab栏数据
  const [tabList, setTabList] = useState<
    { label: string; value: any[]; api: any }[]
  >([
    {
      label: '热点资讯',
      value: [],
      api: HomeAPI.getListNews,
    },
    {
      label: '招标快讯',
      value: [],
      api: HomeAPI.getListTenderInfo,
    },
    // {
    //   label: '行业新闻',
    //   value: [],
    // },
  ]);
  // 跳转到更多了
  const handleMore = async () => {
    await router.push('/news');
  };
  // 选择tab栏
  const handleSelect = async (index: number) => {
    setCurrentIndex(index);
  };
  // 获取所有新闻数据
  const getListNewsAll = async () => {
    const res = await Promise.all(
      tabList?.map(
        (i) =>
          i?.api?.({
            pageNo: 1,
            pageSize: 6,
          }),
      ),
    );
    setTabList(
      tabList?.map((i, j) => ({ ...i, value: res[j]?.result?.list ?? [] })),
    );
  };
  // 跳转详情
  const handleDetail = async (item: { id: number }, index: number) => {
    await router.push(`/news/detail/${item.id}?type=${index + 1}`);
  };
  // 组件挂载
  useEffect(() => {
    getListNewsAll().then();
  }, []);
  return (
    <HomeNewsWrap>
      <div className="news-tab flex-between">
        <div className="tab-list flex-start">
          {tabList?.map((i, j) => (
            <div
              className={`tab-item ${currentIndex === j && 'tab-active'}`}
              key={j}
              onClick={() => handleSelect(j)}
            >
              {i?.label}
            </div>
          ))}
        </div>
        <div className="tab-more flex-end" onClick={handleMore}>
          <div className="text">更多</div>
          <RightOutlined />
        </div>
      </div>
      <div className="news-list">
        {tabList?.[currentIndex]?.value?.map((i, j) => (
          <div
            className="list-item text-ellipsis"
            key={j}
            onClick={() => handleDetail(i, currentIndex)}
          >
            {i?.newsTitle || i?.tenderTitle}
          </div>
        ))}
      </div>
    </HomeNewsWrap>
  );
};

export default HomeNewsView;
// 样式
const HomeNewsWrap = styled.div`
  position: relative;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 5rem;
  .news-tab {
    position: relative;
    width: 100%;
    height: 2.33rem;
    box-sizing: border-box;
    border-bottom: 2px solid #ff552d;
    margin-bottom: 0.5rem;
    .tab-list {
      position: relative;
      box-sizing: border-box;
      .tab-item {
        font-weight: 550;
        font-size: 15px;
        color: #ff552d;
        box-sizing: border-box;
        padding: 0 1rem;
        height: 2.33rem;
        line-height: 2.33rem;
        cursor: pointer;
      }
      .tab-active {
        color: #fff;
        background: #ff552d;
      }
    }
    .tab-more {
      color: #ff552d;
      cursor: pointer;
    }
  }
  .news-list {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    .list-item {
      position: relative;
      width: 100%;
      box-sizing: border-box;
      height: 2rem;
      line-height: 2rem;
      cursor: pointer;
      background: #fff;
      padding: 0 0 0 1rem;
      font-weight: 400;
      font-size: 13px;
      color: #333333;
      &:hover {
        filter: brightness(0.96);
        color: #ff552d;
        &:after {
          background: #ff552d;
        }
      }
      &:after {
        position: absolute;
        content: '';
        left: 2px;
        top: calc((2rem - 6px) / 2);
        width: 6px;
        height: 6px;
        background: #333333;
        border-radius: 50%;
      }
    }
  }
`;
