import React, { useEffect } from 'react';
import { Spin } from 'antd';
import { useDispatch, useSelector } from 'react-redux';
import { ContentWrap } from '@/components/layout/content/styled';
import { GlobalDataState, setGlobalData } from '@/store/module/globalData';

const ContentView = ({ children }: { children?: React.ReactNode }) => {
  // store
  const dispatch = useDispatch();
  // globalData
  const globalData = useSelector(
    (state: any) => state.globalData,
  ) as GlobalDataState;
  // 页面挂载时自动将加载中移除
  useEffect(() => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: false,
      }),
    );
  }, []);
  return (
    <div className={'animate__animated animate__faster animate__fadeIn'}>
      <Spin spinning={globalData?.loadingSpinnerVisible} fullscreen />
      <ContentWrap>{!!children && children}</ContentWrap>
    </div>
  );
};

export default ContentView;
