import { Button, Col, Image, Modal, Row, Space } from "antd";
import { useState } from "react";
import errImg from "~/assets/errImg";
import { GetAppGoodsInfoDetailResult } from "../../api";
import styles from "./index.module.scss";

type Props = {
  open?: boolean;
  onOk?: (e: React.MouseEvent<HTMLButtonElement>) => void;
  onCancel: (e: React.MouseEvent<HTMLButtonElement>) => void;
  detail: GetAppGoodsInfoDetailResult | null;
};
export default function IntentionModal(props: Props) {
  const [checkedMap, setCheckedMap] = useState<{ string?: boolean }>({}); //通过索引记录选中的产品规格 例: {'1,1': true|false}

  //添加规格到购物车
  function addProductSpec(goodsSpecIndex: number, productSpecIndex: number) {
    let temp = {};
    //@ts-ignore
    temp[`${goodsSpecIndex},${productSpecIndex}`] =
      //@ts-ignore
      !checkedMap[`${goodsSpecIndex},${productSpecIndex}`];

    setCheckedMap({
      ...checkedMap,
      ...temp,
    });
  }

  return (
    <Modal
      open={props.open}
      onOk={props.onOk}
      onCancel={props.onCancel}
      width={420}
      style={{ padding: 0 }}
      className={styles.model}
      footer={
        <div style={{ padding: "13px 36px" }}>
          <Button
            type="primary"
            className={styles.font5}
            style={{ width: "100%", height: 44 }}
          >
            提交意向
          </Button>
        </div>
      }
    >
      <Row style={{ padding: "22px 39px 12px 39px" }} wrap={false}>
        <Col>
          <Image
            width={100}
            height={100}
            fallback={errImg}
            style={{ borderRadius: 8 }}
            src={props.detail?.images?.[0]?.imgUrl}
          ></Image>
        </Col>
        <Col flex="auto" style={{ marginLeft: 13, width: 230 }}>
          <div
            className={`${styles.font1} ${styles.ellipsis1}`}
            style={{ marginTop: 28 }}
          >
            {props.detail?.goodsName}
          </div>
          <div
            className={`${styles.font2} ${styles.ellipsis2}`}
            style={{ marginTop: 7 }}
          >
            已选:
          </div>
        </Col>
      </Row>
      <div style={{ paddingRight: 13 }}>
        <div className={styles.specsContent}>
          <div className={styles.font3} style={{}}>
            无人机
          </div>
          {props.detail?.goodsSpec?.map((item, goodsSpecIndex) => {
            return (
              <div key={item.id}>
                <div
                  className={styles.font2}
                  style={{ marginBottom: 5, marginTop: 11 }}
                >
                  {item.goodsSpecName}
                </div>
                <Space size={10} direction="vertical" style={{ width: "100%" }}>
                  {item.productSpecList?.map((product, productSpecIndex) => {
                    return (
                      <Row
                        key={product.id}
                        align="middle"
                        wrap={false}
                        style={{
                          borderRadius: 5,
                          //@ts-ignore
                          border: checkedMap[
                            `${goodsSpecIndex},${productSpecIndex}`
                          ]
                            ? "1px solid #FF552D"
                            : "1px solid #d6d6d6",
                          height: 50,
                          cursor: "pointer",
                        }}
                        onClick={() =>
                          addProductSpec(goodsSpecIndex, productSpecIndex)
                        }
                      >
                        <Col style={{ marginLeft: 7 }}>
                          <Image
                            width={52}
                            height={36}
                            src={product.specImage}
                            fallback={errImg}
                            preview={false}
                          ></Image>
                        </Col>
                        <Col
                          className={`${styles.ellipsis1} ${styles.font4}`}
                          style={{ width: 238, marginLeft: 18 }}
                        >
                          {product.specName}
                        </Col>
                      </Row>
                    );
                  })}
                </Space>
              </div>
            );
          })}
        </div>
      </div>
    </Modal>
  );
}
