import React from 'react';
import { CheckCircleOutlined } from '@ant-design/icons';
import { Modal } from 'antd';
import styled from 'styled-components';

const ToastModalView: React.FC<{
  open: boolean;
  onCancel: () => void;
}> = ({ open, onCancel }) => {
  return (
    <Modal
      open={open}
      title={'提示'}
      onCancel={onCancel}
      width={400}
      footer={null}
    >
      <ToastModalWrap>
        <CheckCircleOutlined style={{ color: '#07c160', fontSize: 68 }} />
        <div className="toast-title">订单提交成功</div>
      </ToastModalWrap>
    </Modal>
  );
};

export default ToastModalView;
// 样式
const ToastModalWrap = styled.div`
  position: relative;
  width: 100%;
  height: 16.8rem;
  display: flex;
  justify-content: flex-start;
  align-items: center;
  flex-direction: column;
  box-sizing: border-box;
  padding-top: 3rem;
  .toast-title {
    font-size: 20px;
    font-weight: bold;
    margin-top: 2.5rem;
  }
`;
