import styled from 'styled-components';

export default function Style() {
  return <></>;
}

export const HomeTabWrap = styled.div`
  position: relative;
  height: 100%;
  width: calc(100% - 25rem - 1rem);
  min-width: 680px;
  margin-right: 1rem;
  //background: lavender;
  display: flex;
  align-items: flex-start;
  justify-content: flex-start;
  .tab-label {
    position: relative;
    height: 100%;
    width: 8.58rem;
    .label-head {
      position: relative;
      width: 8.58rem;
      height: 3.58rem;
      background: #ff7202;
      line-height: 3.58rem;
      box-sizing: border-box;
      padding: 0 1rem;
      font-size: 0.92rem;
      font-weight: bold;
      color: #ffffff;
    }
    .label-item {
      position: relative;
      width: 8.58rem;
      height: 3.75rem;
      margin-bottom: 0.42rem;
      box-sizing: border-box;
      .item-image {
        width: 3.08rem;
        height: 2.08rem;
      }
      .item-name {
        font-size: 0.83rem;
        font-weight: 550;
        color: #333333;
        margin-left: 0.33rem;
      }
      &:hover,
      &:active {
        background: #fff4f4;
      }
      &:hover::after,
      &:active::after {
        position: absolute;
        content: '';
        top: 0;
        left: 0;
        width: 0.13rem;
        height: 100%;
        background: #ff7202;
      }
    }
    .item-active {
      background: #fff4f4;
      &::after {
        position: absolute;
        content: '';
        top: 0;
        left: 0;
        width: 0.13rem;
        height: 100%;
        background: #ff7202;
      }
    }
  }
  .tab-content {
    position: relative;
    width: 100%;
    height: 100%;
    box-sizing: border-box;
    overflow: hidden;
    // 超出滚动
    //overflow-y: auto;
    border: 0.04rem solid #e3e3e3;
    &::-webkit-scrollbar-thumb {
      background: #d9d9d9;
      -webkit-border-radius: 2em;
      -moz-border-radius: 2em;
      border-radius: 2em;
      cursor: pointer;
    }
    &::-webkit-scrollbar {
      background-color: transparent;
      -webkit-border-radius: 2em;
      -moz-border-radius: 2em;
      border-radius: 2em;
      width: 7px;
      height: 7px;
    }
  }
  @media (prefers-color-scheme: dark) {
    .tab-label {
      .label-item {
        .item-name {
          color: #fff;
        }
      }
      .item-active {
        .item-name {
          color: #000;
        }
      }
    }
  }
`;
