import React, { useEffect, useState } from "react";
import {
  Tabs,
  Button,
  Cascader,
  Space,
  DatePicker,
  DatePickerProps,
} from "antd";
import styles from "./index.module.scss";
import Layout from "~/components/layout";
import Requirements from "./components/requirements"; //项目需求
import Bids from "./components/bids"; //招投标项目
import Cases from "./components/cases"; //业务案例
import News from "./components/news"; //行业新闻

interface Option {
  value: string | number;
  label: string;
  children?: Option[];
}

const options: Option[] = [
  {
    value: "zhejiang",
    label: "Zhejiang",
    children: [
      {
        value: "hangzhou",
        label: "Hangzhou",
        children: [
          {
            value: "xihu",
            label: "West Lake",
          },
        ],
      },
    ],
  },
  {
    value: "jiangsu",
    label: "Jiangsu",
    children: [
      {
        value: "nanjing",
        label: "Nanjing",
        children: [
          {
            value: "zhonghuamen",
            label: "Zhong Hua Men",
          },
        ],
      },
    ],
  },
];

const onChange = (value: string) => {
  console.log(value);
};

const onDateChange: DatePickerProps["onChange"] = (date, dateString) => {
  console.log(date, dateString);
};

const operations = (
  <Space size={8} style={{ marginRight: 25 }}>
    {
      <Cascader
        options={options}
        //@ts-ignore
        onChange={onChange}
        placeholder="Please select"
        borderRadiusSM={6}
      />
    }
    <DatePicker onChange={onDateChange} />
  </Space>
);

const items = ["项目需求", "招投标项目", "业务案例", "行业新闻"].map(
  (value) => {
    let children: JSX.Element | string = <></>;

    switch (value) {
      case "项目需求":
        children = <Requirements></Requirements>;
        break;

      case "招投标项目":
        children = <Bids></Bids>;
        break;

      case "业务案例":
        children = <Cases></Cases>;
        break;

      case "行业新闻":
        children = <News></News>;
        break;
    }
    return {
      label: `${value}`,
      key: value,
      children: children,
    };
  }
);

export default function ProjectInfo() {
  return (
    <Layout layoutStyle={{ backgroundColor: "#fff" }}>
      <div style={{ backgroundColor: "#fff", minHeight: 820 }}>
        <div className="page">
          <div className={styles.bannerWrap}>
            <div className={styles.banner}></div>
          </div>

          <Tabs
            className={styles.tabs}
            tabBarExtraContent={operations}
            items={items}
            tabBarGutter={41}
          />
        </div>
      </div>
    </Layout>
  );
}
