import { Button } from "antd";
import { useRouter } from "next/router";
import { useState, useEffect } from "react";
import api, { Item } from "./api";
import styles from "./index.module.scss";

const list = [
  {
    isApply: false,
  },
  {
    isApply: true,
  },
];

export default function Cases() {
  const [list, setList] = useState<Array<Item>>([]);
  const [pageParams, setPageParams] = useState({
    pageNo: 1,
    pageSize: 5,
  });
  const [count, setCount] = useState(0);
  const [abort, setAbort] = useState<AbortController | null>(null);
  const Router = useRouter();

  useEffect(() => {
    //中断前一次请求
    abort?.abort();
    setAbort(new AbortController());
  }, [pageParams]);

  useEffect(() => {
    if (!abort) {
      return;
    }
    api
      .listCasePage(
        {
          ...pageParams,
        },
        {
          signal: abort?.signal,
        }
      )
      .then((res) => {
        setList(res.result?.list || []);
        setCount(res.result?.totalCount || 0);
      });
  }, [abort]);

  return (
    <div className={styles.casas}>
      {list.map((item) => {
        return (
          <div className={styles.item} key={item.id}>
            <div className={styles.info}>
              <div className={styles.title}>{item.caseTitle}</div>
            </div>
            <Button
              className={styles.btn}
              onClick={() => Router.push("/projectInfo/caseArticle/" + item.id)}
            >
              查看案例
            </Button>
          </div>
        );
      })}
    </div>
  );
}
