import { Button } from "antd";
import { useState, useEffect } from "react";
import api, { Item } from "./api";
import styles from "./index.module.scss";

export default function Bids() {
  const [list, setList] = useState<Array<Item>>([]);
  const [pageParams, setPageParams] = useState({
    pageNo: 1,
    pageSize: 5,
  });
  const [count, setCount] = useState(0);
  const [abort, setAbort] = useState<AbortController | null>(null);

  useEffect(() => {
    //中断前一次请求
    abort?.abort();
    setAbort(new AbortController());
  }, [pageParams]);

  useEffect(() => {
    if (!abort) {
      return;
    }
    api
      .listNewTenderInfo(
        {
          ...pageParams,
        },
        {
          signal: abort?.signal,
        }
      )
      .then((res) => {
        setList(res.result?.list || []);
        setCount(res.result?.totalCount || 0);
      });
  }, [abort]);

  return (
    <div className={styles.bids}>
      {list.map((item) => {
        return (
          <div className={styles.item} key={item.id}>
            <div className={styles.info}>
              <div className={styles.title}>项目需求：{item.tenderContent}</div>
            </div>
            {item.apply ? (
              <Button
                type="primary"
                disabled
                className={`${styles.btn} ${styles.disabled}`}
              >
                <div className={styles.text1}>{item.tenderPrice}元</div>
                <div className={styles.text2}>已申请</div>
              </Button>
            ) : (
              <Button type="primary" className={styles.btn}>
                <div className={styles.text1}>{item.tenderPrice}元</div>
                <div className={styles.text2}>申请合作</div>
              </Button>
            )}
          </div>
        );
      })}
    </div>
  );
}
