import CategoryItem from "./compoents/categoryItem";
import { FilterOptionResp, RegionResp } from "./api";
import ResultItem from "./compoents/resultItem";
import RegionItem from "./compoents/regionItem";
import styles from "./index.module.scss";
import { useEffect, useState } from "react";
import BrandItem from "./compoents/brandItem";
import ModelItem from "./compoents/modelItem";
import PartItem from "./compoents/partItem";
import QualityItem from "./compoents/qualityItem";
import Industry from "./compoents/industry";
import AppType from "./compoents/appType";
import DeviceBrand from "./compoents/deviceBrand";
import DeviceModel from "./compoents/deviceModel";

export type AdapterResult = {
  brandId?: number;
  districtId?: number;
  modelId?: number;
  partsId?: number;
  productCategoryId?: number;
  qualityId?: number;
  industryId?: number;
  appTypeId?: number;
  categoryId?: number;
};

export type FilterResult = {
  region?: RegionResp;
  brand?: FilterOptionResp;
  category?: FilterOptionResp;
  part?: FilterOptionResp;
  model?: FilterOptionResp;
  quality?: FilterOptionResp;
  industryId?: FilterOptionResp;
  appTypeId?: FilterOptionResp;
  categoryId?: FilterOptionResp;
};

type itemType =
  | "类目"
  | "地域"
  | "品牌"
  | "部件"
  | "型号"
  | "成色"
  | "行业"
  | "应用"
  | "设备品牌"
  | "设备型号"
  | "设备类目";

type Props = {
  types: itemType[]; //需要包含的筛选条件项
  showResultItem: Boolean; //显示结果栏
  onChange: (
    filterResult: FilterResult,
    adapterFilterResult: AdapterResult //适配器,直接用于接口请求
  ) => void; //筛选条件更改事件
};
export default function Filter(props: Props) {
  const [result, setResult] = useState<FilterResult>({});
  const onChange = (item: FilterOptionResp, type: string) => {
    console.log(item, type);

    let data: { [key: string]: FilterOptionResp } = {};
    data[type] = item;
    console.log(data);

    setResult({ ...result, ...data });
  };

  useEffect(() => {
    props.onChange(result, {
      brandId: result.brand?.id,
      districtId: result.region?.id,
      modelId: result.model?.id,
      partsId: result.part?.id,
      productCategoryId: result.category?.id,
      qualityId: result.quality?.id,
      industryId: result.industryId?.id,
      appTypeId: result.appTypeId?.id,
      categoryId: result.categoryId?.id,
    });
  }, [result]);
  const onDel = (key: string) => {
    //@ts-ignore
    delete result[key];
    setResult({
      ...result,
    });
  };
  return (
    <>
      {props.types.includes("地域") && (
        <div
          className={styles.filterWrap}
          style={{
            marginBottom: 18,
          }}
        >
          <RegionItem
            onChange={(item: FilterOptionResp) => onChange(item, "region")}
          ></RegionItem>
        </div>
      )}
      <div className={styles.filterWrap}>
        {props.types.includes("品牌") && (
          <BrandItem
            onChange={(item: FilterOptionResp) => onChange(item, "brand")}
          ></BrandItem>
        )}
        {props.types.includes("设备品牌") && (
          <DeviceBrand
            onChange={(item: FilterOptionResp) => onChange(item, "brand")}
          ></DeviceBrand>
        )}
        {props.types.includes("类目") && (
          <CategoryItem
            onChange={(item: FilterOptionResp) => onChange(item, "category")}
          ></CategoryItem>
        )}
        {props.types.includes("设备类目") && (
          <CategoryItem
            onChange={(item: FilterOptionResp) => onChange(item, "categoryId")}
          ></CategoryItem>
        )}
        {props.types.includes("部件") && (
          <PartItem
            onChange={(item: FilterOptionResp) => onChange(item, "part")}
          ></PartItem>
        )}
        {props.types.includes("型号") && (
          <ModelItem
            onChange={(item: FilterOptionResp) => onChange(item, "model")}
          ></ModelItem>
        )}
        {props.types.includes("设备型号") && (
          <DeviceModel
            onChange={(item: FilterOptionResp) => onChange(item, "model")}
          ></DeviceModel>
        )}
        {props.types.includes("成色") && (
          <QualityItem
            onChange={(item: FilterOptionResp) => onChange(item, "quality")}
          ></QualityItem>
        )}
        {props.types.includes("行业") && (
          <Industry
            onChange={(item: FilterOptionResp) => onChange(item, "industryId")}
          ></Industry>
        )}
        {props.types.includes("应用") && (
          <AppType
            onChange={(item: FilterOptionResp) => onChange(item, "appTypeId")}
          ></AppType>
        )}

        {props.showResultItem && (
          <ResultItem data={result} onDel={onDel}></ResultItem>
        )}
      </div>
    </>
  );
}
