// user.ts
import { createSlice } from '@reduxjs/toolkit';
import { HYDRATE } from 'next-redux-wrapper';

export type SystemState = {
  token?: string;
};

const initialState: SystemState = {
  token: undefined,
};

const systemSlice = createSlice({
  name: 'system',
  initialState,
  reducers: {
    setSystem: (state, action) => {
      return action.payload;
    },
  },
  extraReducers: {
    // hydrated 用于获取服务端注入的state并选择更新
    [HYDRATE]: (state, action) => {
      return {
        ...action.payload.system,
      };
    },
  },
});

export const { setSystem } = systemSlice.actions;
export default systemSlice.reducer;
