import React from 'react';
import { Breadcrumb } from 'antd';
import { useRouter } from 'next/router';
import styled from 'styled-components';

const BreadcrumbWrap = styled.div`
  position: relative;
  width: 100%;
  display: flex;
  align-content: center;
  justify-content: flex-start;
  .title {
    font-size: 13px;
    font-weight: 400;
    color: #666666;
    margin-bottom: 0.75rem;
  }
`;

const BreadcrumbView: React.FC = () => {
  // 路由钩子
  const router = useRouter();
  // 路由对应列表
  const routerList = [
    { name: '云享商城', path: '/mall' },
    { name: '行业服务', path: '/service' },
    { name: '设备租赁', path: '/rent' },
    { name: '执照培训', path: '/train' },
    { name: '飞手约单', path: '/flyer' },
  ];
  return (
    <BreadcrumbWrap>
      <div className="title">您的位置：</div>
      <Breadcrumb
        separator=">"
        items={[
          {
            title: '首页',
            href: '/',
          },
          {
            title: routerList.find((i) => i.path === router?.pathname)?.name,
            href: router?.pathname,
          },
        ]}
      />
    </BreadcrumbWrap>
  );
};

export default BreadcrumbView;
