import React, { useEffect, useState } from "react";
import { Button, Empty, Pagination, Select, Space, Tag } from "antd";
import Layout from "~/components/layout";
import styles from "./index.module.scss";
import { useRouter } from "next/router";
import Image from "next/image";
import Filter, { FilterResult } from "~/components/filter";
import api, { Goods, ListPageGoodsInfoParams } from "./api";

// 此函数在构建时被调用
export async function getServerSideProps() {
  return {
    props: {},
  };
}

type Props = {};

export default function Mall(props: Props) {
  const router = useRouter();
  const [productList, setProductList] = useState(Array<Goods>);
  const [filterResult, setFilterResult] = useState<FilterResult>({});
  const [pageParams, setPageParams] = useState({
    pageNo: 1,
    pageSize: 16,
  });
  const [count, setCount] = useState(0);
  const [abort, setAbort] = useState<AbortController | null>(null);

  useEffect(() => {
    //中断前一次请求
    abort?.abort();
    setAbort(new AbortController());
  }, [filterResult, pageParams]);

  useEffect(() => {
    api
      .listPageGoodsInfo(
        {
          brandId: filterResult.brand?.id,
          districtId: filterResult.region?.id,
          modelId: filterResult.model?.id,
          partsId: filterResult.part?.id,
          productCategoryId: filterResult.category?.id,
          qualityId: filterResult.quality?.id,
          ...pageParams,
        },
        {
          signal: abort?.signal,
        }
      )
      .then((res) => {
        setProductList(res.result?.list || []);
        setCount(res.result?.totalCount || 0);
      });
  }, [abort]);

  const onFilterChange = (filterResult: FilterResult) => {
    console.log("filterResult", filterResult);
    setFilterResult(filterResult);
  };

  const onPageChange = (page: number, pageSize: number) => {
    setPageParams({
      ...pageParams,
      pageNo: page,
    });
  };
  return (
    <Layout>
      <div className="page" style={{ paddingTop: "18px" }}>
        <Filter
          types={["类目", "地域", "品牌", "部件", "型号", "成色"]}
          showResultItem
          onChange={onFilterChange}
        ></Filter>
        <div className={styles.productList}>
          <div className={styles.title}>四旋翼无人机</div>
          <div className={styles.main}>
            <div className={styles.listContent}>
              <ul className={styles.listWrap}>
                {productList.map((item, i) => {
                  return (
                    <li
                      key={i}
                      className={styles.item}
                      onClick={() => router.push("/mall/detail/1")}
                    >
                      <div className={styles.imgBox}>
                        <Image
                          alt=""
                          src={item.imgUrl}
                          className={styles.img}
                          width={116}
                          height={116}
                        ></Image>
                      </div>
                      <div className={styles.title}>{item.goodsName}</div>
                      <div className={styles.sellCount}>
                        半年售
                        {(Math.floor(Math.random() * 901) + 100).toFixed(0)}
                      </div>
                    </li>
                  );
                })}
                {productList.length === 0 && (
                  <Empty style={{ paddingTop: 20, width: '100%', textAlign: "center" }}></Empty>
                )}
              </ul>
              <Pagination
                current={pageParams.pageNo}
                showSizeChanger={false}
                showQuickJumper
                total={count}
                onChange={onPageChange}
                hideOnSinglePage={true}
                style={{marginTop: 20}}
              />
            </div>

            <div className={styles.adList}>
              <div className={styles.ad}></div>
              <div className={styles.ad}></div>
            </div>
          </div>
        </div>
      </div>
    </Layout>
  );
}
