import React, { useEffect, useState } from "react";
import {Box} from './styled';
import { Button, Select, Space, Tag } from "antd";
import Layout from "~/components/layout";
import ContentBox from '~/components/contentBox';
import { useRouter } from "next/router";
import Filter, { FilterResult } from "~/components/filter";
import api from "./api";
import {DomType} from '~/components/contentBox/interface';
// 此函数在构建时被调用
export async function getServerSideProps() {
  return {
    props: {},
  };
}

export default function JobServices() {
  const router = useRouter();

  const leftDom = <div className='item' onClick={() => router.push('/jobServices/detail/1')}>
    <div className="item-top">
        <div className="value">
                <div className="value-left">
                  <div className="label">asdasdasdasdasasdasdasdasdasasdasdasdasdas</div>
                  <div className="com">asdasdasdasdas</div>
                </div>
                <div className="value-right"><span className="money">¥6600</span> <span className="unit">/平</span></div>
        </div>
    </div>
    <div className="item-bottom">
          <div className="bottom-left">114条评价</div>
          <div className="bottom-right">专业飞手团队，精通巡航业务</div>
    </div>
  </div>

  const rightDom = <div className="advertisement">
        112312312312
  </div>

  const [productList, setProductList] = useState(Array<{element:JSX.Element}>);

  useEffect(() => {
    api
      .listPageJobServicesInfo({
        pageNo: 1,
        pageSize: 10,
      })
      .then((res) => {
        // setProductList(res.result?.list || []);
        
        setProductList(res.result?.list.map(item=>{return { element:<div key={item.id} className='item' onClick={() => router.push('/jobServices/detail/1')}>
        <div className="item-top">
            <div className="value">
                    <div className="value-left">
                      <div className="label">{item.serviceName}</div>
                      <div className="com">{item.teamName}</div>
                    </div>
                    <div className="value-right"><span className="money">{item.price}</span> <span className="unit">/平</span></div>
            </div>
        </div>
        <div className="item-bottom">
              <div className="bottom-left">{ Math.round( Math.random()*(150-100)+100) }条评价</div>
              <div className="bottom-right">专业飞手团队，精通巡航业务</div>
        </div>
      </div> }}) || [])
        
      });
  }, []);

  const onFilterChange = (filterResult: FilterResult) => {
    console.log('filterResult', filterResult)
  }

  return  (
    <Layout>
      <Box>
      <Filter
          types={[ "地域", "类目", "品牌", "型号"]}
          showResultItem
          onChange={onFilterChange}
        ></Filter>
        <div style={{marginTop:18}}>
          <ContentBox boxIndex={2}
          leftRenderDom={{columns:productList}} 
            rightRenderDom={{columns:[{element:rightDom}]}}
            leftcontentstyle={{width:"924px",margin:{top:0,right:"16px",bottom:"16px",left:0}}}
            />
        </div>
      </Box>
    </Layout>
  )
}
