import React , {useEffect,useState} from 'react';
import {Box} from './styled';
// import Image from 'next/image';
import { Button, Select, Space } from "antd";
import Layout from "~/components/layout";
import ContentBox from '~/components/contentBox';
import api , {Flying} from "./api";

export default function FlyingHandService() {
  const [productList, setProductList] = useState(Array<{element:JSX.Element}>);

  const leftDom = (item:Flying)=>{
    return (<div className='item' key={item.id}>
    <div className='item-top'>
    {/* <Image src={require("./assets/icon.png")} alt='#'/> */}
    </div>
    <div className='item-bottom'>
          <div className="bottom-title">{item.curriculumName}</div>
          <div className="bottom-details">{item.curriculumDesc}</div>
          <div className='bottom-price'>
            <div className='bottom-price-left' title={item.supplierName}>{item.supplierName}</div>
            <div className='bottom-price-right'>
              {
                item.free ? <div className='price-right-label'>{item.price}</div> : <div>
                  <span className='price-right-label'>限免</span>
                <span className='price-right-money'>{`¥${item.price}`}</span>
                </div>
              }
            </div>
          </div>
    </div>
  </div>)
  }

    const rightDom = <div className='right-item' key={1}>
     </div>

  const onProvinceChange = (value: string) => {
    console.log("省", value);
  };

  useEffect(() => {
    api
      .listPageJobServicesInfo({
        pageNo: 1,
        pageSize: 10,
      })
      .then((res) => {
        setProductList(res.result?.list.map(item=>{return { element:leftDom(item) }}) || [])
        
      });
  }, []);

  return (
    <Layout>
      <Box>
        <div className='flyingTop'>
          <div className='flyingTop-left'>
            <Space>
              <Select
                  className='selectItem'
                  bordered={false}
                  popupMatchSelectWidth={false}
                  placeholder="区域"
                  size="large"
                  onChange={onProvinceChange}
                  options={[
                    { value: "jack", label: "Jack" },
                    { value: "lucy", label: "Lucy" },
                    { value: "Yiminghe", label: "yiminghe" },
                    { value: "disabled", label: "Disabled", disabled: true },
                  ]}
                />
                 <Select
                  className='selectItem'
                  bordered={false}
                  popupMatchSelectWidth={false}
                  placeholder="考证"
                  size="large"
                  onChange={onProvinceChange}
                  options={[
                    { value: "jack", label: "Jack" },
                    { value: "lucy", label: "Lucy" },
                    { value: "Yiminghe", label: "yiminghe" },
                    { value: "disabled", label: "Disabled", disabled: true },
                  ]}
                />
                <Select
                  className='selectItem'
                  bordered={false}
                  popupMatchSelectWidth={false}
                  placeholder="技能"
                  size="large"
                  onChange={onProvinceChange}
                  options={[
                    { value: "jack", label: "Jack" },
                    { value: "lucy", label: "Lucy" },
                    { value: "Yiminghe", label: "yiminghe" },
                    { value: "disabled", label: "Disabled", disabled: true },
                  ]}
                />
            </Space>
          </div>
          <Button type="primary" className='btn'>报名学习课程</Button>
        </div>
        <ContentBox boxIndex={4} leftcontentstyle={{width:"925px",margin:{top:0,right:"15px",bottom:"15px",left:0}}} leftRenderDom={{columns:productList}} rightRenderDom={{columns:[{element:rightDom}]}}/>
      </Box>
    </Layout>
  );
}
