import request, { Response } from '~/api/request';

export interface ListPageFlyingInfoParams {
  pageNo: number,
  pageSize: number,
  flightSkillsId?:number,
  licenseId?:number,
  regionId?:number
}

export interface Flying {
  curriculumName:string,
  curriculumDesc:string,
  supplierName:string,
  free: 0 | 1,
  price:number,
  id:number,
}

export interface ListPageFlyingInfoResp {
  pageNo: 1,
  pageSize: 10,
  list: Array<Flying>,
  totalCount: 0,
  totalPage: 0
}


export default {
  //web-作业服务-分页
  listPageJobServicesInfo: (params: ListPageFlyingInfoParams): Promise<Response<ListPageFlyingInfoResp>> => {
    return request('/release/curriculum/queryCurriculumInfoList', 'post', params)
  }
}