import React, { useEffect, useState } from "react";
import { useRouter } from "next/router";
import { Button, Select, Space, Tag } from "antd";
import {Box} from './styled';
import Layout from "~/components/layout";
import ContentBox from '~/components/contentBox';
import Filter, { FilterResult } from "~/components/filter";
import { FilterOptionResp } from "~/components/filter/api";

// 此函数在构建时被调用
export async function getStaticProps() {
  //获取筛选数据，进行静态渲染
  return {
    props: {
    },
  };
}

type Props = {
};

export default function EquipmentLeasing(props:Props) {
  const router = useRouter();

  const leftDom = <div className='item' onClick={() => router.push('/equipmentLeasing/detail/1')}>
    <div className="item-top">
        <div className="item-top-image"></div>
    </div>
    <div className="item-bottom">
      <div className="item-bottom-title">入云龙ll 1550入云龙ll入</div>
      <div className="item-bottom-price">
        <span className="money">¥23</span>
        <span className="unit">/天起</span>
      </div>
    </div>
  </div>

  const rightDom = <div className="right-box-item right-item">

  </div>

  const onFilterChange = (filterResult: FilterResult) => {
    console.log('filterResult', filterResult)
  }

  return  (
    <Layout>
      <Box>
       <Filter
          types={[ "地域", "类目", "品牌", "型号"]}
          showResultItem
          onChange={onFilterChange}
        ></Filter>
       <div style={{paddingTop:13}}>
         <ContentBox boxIndex={4} leftcontentstyle={{width:"916px",margin:{top:0,right:"12px",bottom:"12px",left:0}}} leftRenderDom={{columns:[{element:leftDom},{element:leftDom},{element:leftDom},{element:leftDom},{element:leftDom},{element:leftDom},{element:leftDom}]}} rightRenderDom={{columns:[{element:rightDom},{element:rightDom}]}}/>
       </div>
      </Box>
    </Layout>
  )
}
