import request, { Response } from '~/api/request';

export interface ListPageGoodsInfoParams {
  "brandId"?: number,
  "districtId"?: number,
  "modelId"?: number,
  "pageNo": number,
  "pageSize": number,
  "partsId"?: number,
  "productCategoryId"?: number,
  "qualityId"?: number
}

export interface Goods {
  "createTime": string,
  "directoryId": number,
  "directoryName": string,
  "goodsName": string,
  "goodsOneLevelTypeName": string,
  "goodsTwoLevelTypeName": string,
  "id": number,
  "imgUrl": string,
  "isCoupons": number,
  "status": number
}

export interface ListPageGoodsInfoResp {
  "pageNo": 1,
  "pageSize": 10,
  "list": Array<Goods>,
  "totalCount": 0,
  "totalPage": 0
}


export default {
  //web-设备租赁-分页
  listPageGoodsInfo: (params: ListPageGoodsInfoParams): Promise<Response<ListPageGoodsInfoResp>> => {
    return request('/pms/webProductMall/listPageGoodsInfo', 'post', params)
  }
}