// 随机生成
export const RandomNum = (minNum: number, maxNum: number) => {
  return parseInt(String(Math.random() * (maxNum - minNum + 1) + minNum), 10);
};
// 授权
export const RandomShareImg = () => {
  const ImgList = [
    'https://share-fly.oss-cn-hangzhou.aliyuncs.com/file/shareCard20230718.jpg',
  ];
  return ImgList[parseInt(String(Math.random() * ImgList.length), 10)];
};

// 判空
export const isNone = (val: string | number | null | undefined) => {
  return val === null || val === undefined || val === '';
};

// 判零和空
export const isNoneZero = (val: string | number | null | undefined) => {
  return val === null || val === undefined || val === '' || val === 0;
};

// 随机获取数组中的元素
export function getRandomArrayElements(arr: any[], count: number) {
  const shuffled = arr.slice(0);
  let i = arr.length;
  const min = i - count;
  let temp;
  let index; // 只是声明变量的方式, 也可以分开写
  // eslint-disable-next-line no-plusplus
  while (i-- > min) {
    // console.log(i);
    index = Math.floor((i + 1) * Math.random()); // 这里的+1 是因为上面i--的操作  所以要加回来
    temp = shuffled[index]; // 即值交换
    shuffled[index] = shuffled[i];
    shuffled[i] = temp;
    // console.log(shuffled);
  }
  return shuffled.slice(min);
}

// adcode转换为省市区编号
export const adcodeToCode = (
  adcode: string | number,
): {
  provinceCode: string;
  cityCode: string;
  districtCode: string;
} => {
  return {
    provinceCode: String(adcode).replace(/.{4}$/, '0000'),
    cityCode: String(adcode).replace(/.{2}$/, '00'),
    districtCode: String(adcode),
  };
};
