import React from 'react';
import { useRouter } from 'next/router';
import HomeBottomView from '@/pages/home/comp/home-bottom';
import HomeBrandView from '@/pages/home/comp/home-brand';
import HomeMapView from '@/pages/home/comp/home-map';
import HomeNewsView from '@/pages/home/comp/home-news';
import HomeProductView from '@/pages/home/comp/home-product';
import HomeSearchView from '@/pages/home/comp/home-search';
import HomeTabView from '@/pages/home/comp/home-tab';
import HomeTaskView from '@/pages/home/comp/home-task';
import HomeTitleView from '@/pages/home/comp/home-title';
import { HomeWrap } from '@/pages/home/styled';

const HomeView = () => {
  // 路由钩子
  const router = useRouter();
  // 消息提醒
  // const handleClick = async () => {
  //   await message.success('你好');
  // };
  // 跳转测试
  // const handleNavigate = async () => {
  //   await router.push('/mall');
  // };
  return (
    <HomeWrap>
      {/* 主页搜索 */}
      <HomeSearchView />
      {/* 网格布局 */}
      <div className="home-grid">
        {/* 主页分类 */}
        <HomeTabView />
        {/* 全国网点 */}
        <HomeMapView />
        {/* 主页新闻 */}
        <HomeNewsView />
      </div>
      {/* 弹性布局 */}
      <div className="home-wrap">
        {/* 抢单大厅 */}
        <HomeTaskView />
        {/* 品牌企业 */}
        <HomeBrandView />
        {/* 大家都在买 */}
        <HomeTitleView title="大家都在买" />
        {/* 推荐商品 */}
        <HomeProductView />
        {/* 无人机服务 */}
        <HomeTitleView title="无人机服务" />
        {/* 底部标签 */}
        <HomeBottomView />
      </div>
      {/* <h1 className="title">home</h1> */}
      {/* <Button type={'primary'} onClick={handleClick}> */}
      {/*  测试 */}
      {/* </Button> */}
      {/* <Button type={'primary'} onClick={handleNavigate}> */}
      {/*  跳转 */}
      {/* </Button> */}
    </HomeWrap>
  );
};

export default HomeView;
