import styled from 'styled-components';

export const FooterWrap = styled.div`
  position: relative;
  width: 100%;
  background: #2a2a2a;
  .footer-wrap {
    position: relative;
    max-width: 1190px;
    height: 19.13rem;
    box-sizing: border-box;
    margin: 0 auto;
    border-radius: 0;
    opacity: 1;
    //padding: 0 12rem;
    display: flex;
    align-items: center;
    justify-content: flex-end;
    flex-direction: column;
  }
  &::after {
    position: absolute;
    content: '';
    bottom: 5rem;
    left: 12rem;
    width: calc(100% - 24rem);
    height: 0.02rem;
    background: #bfbfbf;
  }
  .footer-end {
    position: relative;
    width: 100%;
    height: 5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    .end-item {
      font-size: 12px;
      font-weight: 400;
      color: rgba(255, 255, 255, 0.68);
      margin-right: 1rem;
      &::after {
        position: absolute;
        content: '';
        top: calc((100% - 0.58rem) / 2);
        right: -0.5rem;
        width: 0.04rem;
        height: 0.58rem;
        background: #979797;
      }
    }
    .end-item:last-child {
      margin-right: 0;
      &::after {
        display: none;
      }
    }
  }
  .footer-start {
    position: relative;
    width: 100%;
    height: calc(100% - 5rem);
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    box-sizing: border-box;
    padding-top: 2.5rem;
    .start-item {
      position: relative;
      min-width: 8.6rem;
      min-height: 8.6rem;
      .item-title {
        font-size: 1rem;
        font-weight: 500;
        color: #ffffff;
        margin-bottom: 1.25rem;
      }
      .item-content {
        width: 11.68rem;
        font-size: 12px;
        font-weight: 400;
        color: rgba(255, 255, 255, 0.8);
      }
      .item-link {
        padding-left: 0;
        padding-right: 0;
        padding-top: 0;
        display: block;
        color: rgba(255, 255, 255, 0.8);
        &:active,
        &:hover {
          color: #ff552d;
        }
      }
      .item-about {
        position: relative;
        display: flex;
        align-items: flex-start;
        justify-content: flex-start;
        .about-item {
          position: relative;
          display: flex;
          align-items: center;
          justify-content: flex-start;
          flex-direction: column;
          margin-right: 1rem;
          .item-logo {
            width: 5rem;
            height: 5rem;
            margin-bottom: 1rem;
          }
          .item-name {
            font-size: 12px;
            font-weight: 400;
            color: rgba(255, 255, 255, 0.8);
          }
          &:last-child {
            margin-right: 0;
          }
        }
      }
    }
  }
  // 媒体查询
  @media screen and (min-width: 1600px) {
    padding: 0 20rem;
    &::after {
      left: 20rem;
      width: calc(100% - 40rem);
    }
  }
`;
