import React from "react";
import { Space, Select, Button } from "antd";
import Image from "next/image";
import { Box } from "./styled";
import ContentBox from "~/components/contentBox";
import RotationChart from "./components/rotationChart";
import Map from "./components/map";
import icon from './assets/icon.png';
// const icon = "error";
export default function WaterfallFlowBody() {
  const onMoreChange = (value: string) => {
    console.log("更多", value);
  };

  const title = [
    {
      name: "无人机出租",
    },
  ];
  const leftDom = (
    <div className="item">
      <div className="item-title">
        <div className="item-left">
          <div className="item-left-icon">
            <Image src={icon} alt="#" />
          </div>
          <div className="item-left-label">无人机出租</div>
        </div>
        <div>
          <Select
            placeholder="更多"
            onChange={onMoreChange}
            bordered={false}
            dropdownMatchSelectWidth={false}
            options={[
              { value: "jack", label: "Jack" },
              { value: "lucy", label: "Lucy" },
              { value: "Yiminghe", label: "yiminghe" },
              { value: "disabled", label: "Disabled", disabled: true },
            ]}
          />
        </div>
      </div>
      <div className="item-body">
        <Space size={[10, 8]} wrap>
          <div className="item-bubble">123123</div>
          <div className="item-bubble active">123123</div>
          <div className="item-bubble">123123</div>
          <div className="item-bubble active">123123</div>
          <div className="item-bubble">123123</div>
          <div className="item-bubble">123123</div>
          <div className="item-bubble">123123</div>
          <div className="item-bubble">123123</div>
        </Space>
      </div>
    </div>
  );

  const rightDom = (
    <div className="right-box-item right-item">
      <div className="title">asdasdas</div>
      <div className="body">
        <div className="body-item">
          <div className="item-label">
            asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
          </div>
          <div className="item-image">
            <Image className="item-image" src={icon} alt="#" />
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
          </div>
          <div className="item-image">
            <Image className="item-image" src={icon} alt="#" />
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
          </div>
          <div className="item-image">
            <Image className="item-image" src={icon} alt="#" />
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
          </div>
          <div className="item-image">
            <Image className="item-image" src={icon} alt="#" />
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
          </div>
          <div className="item-image">
            <Image className="item-image" src={icon} alt="#" />
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
          </div>
          <div className="item-image">
            <Image className="item-image" src={icon} alt="#" />
          </div>
        </div>
      </div>
    </div>
  );

  const rightDom2 = (
    <div className="right-box-item right-item-second">
      <div className="title">asdasdas</div>
      <div className="body">
        <div className="body-item">
          <div className="item-label">
            <div className="label-top">
              asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
            </div>
            <div className="label-bottom">123123</div>
          </div>
          <div className="item-right">
            <Button className="btn" size="small" type="primary">
              申请合作
            </Button>
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            <div className="label-top">
              asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
            </div>
            <div className="label-bottom">123123</div>
          </div>
          <div className="item-right">
            <Button className="btn" size="small" type="primary">
              申请合作
            </Button>
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            <div className="label-top">
              asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
            </div>
            <div className="label-bottom">123123</div>
          </div>
          <div className="item-right">
            <Button className="btn" size="small" type="primary">
              申请合作
            </Button>
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            <div className="label-top">
              asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
            </div>
            <div className="label-bottom">123123</div>
          </div>
          <div className="item-right">
            <Button className="btn" size="small" type="primary">
              申请合作
            </Button>
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            <div className="label-top">
              asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
            </div>
            <div className="label-bottom">123123</div>
          </div>
          <div className="item-right">
            <Button className="btn" size="small" type="primary">
              申请合作
            </Button>
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            <div className="label-top">
              asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
            </div>
            <div className="label-bottom">123123</div>
          </div>
          <div className="item-right">
            <Button className="btn" size="small" type="primary">
              申请合作
            </Button>
          </div>
        </div>
        <div className="body-item">
          <div className="item-label">
            <div className="label-top">
              asdasdasdasjhgdbjasjgdjashgdbjahsdgahjs
            </div>
            <div className="label-bottom">123123</div>
          </div>
          <div className="item-right">
            <Button className="btn" size="small" type="primary">
              申请合作
            </Button>
          </div>
        </div>
      </div>
    </div>
  );

  return (
    <Box>
      <ContentBox
        boxIndex={2}
        leftRenderDom={{
          columns: [
            { noFor: true, element: <RotationChart /> },
            { element: leftDom },
            { element: leftDom },
            { element: leftDom },
            { element: leftDom },
            { element: leftDom },
            { element: leftDom },
          ],
        }}
        rightRenderDom={{
          columns: [
            { element: <Map /> },
            { element: rightDom },
            { element: rightDom2 },
          ],
        }}
      />
    </Box>
  );
}
