import { Space, Button, Select } from 'antd';
import styles from '../../index.module.scss';
import { FilterOptionResp } from "../../api";

type Props = {
  data: Array<FilterOptionResp>;
  onChange: (id: FilterOptionResp) => void;
};

export default function QualityItem(props: Props) {
  const onClick = (item: FilterOptionResp) => {
    props.onChange({
      id: item.id,
      name: "成色：" + item.name,
    });
  };

  return (
    <div className={styles.filterItem}>
      <div className={styles.filterItemTitle}>成色：</div>
      <div className={styles.filterItemMain}>
        <Space size={40}>
          {props?.data?.map((item) => {
            return (
              <Button type="link" key={item.id} onClick={(e) => onClick(item)}>
                {item.name}
              </Button>
            );
          })}
        </Space>
      </div>
    </div>
  );
}