import { Button, Col, Divider, Modal, Row } from 'antd';
import { useContext, useEffect, useState } from 'react';
import { UserContext } from '~/lib/userProvider';
import api, { OrderDetailResp } from './api';
import styles from './index.module.scss';

function formatNumber(num: number) {
  return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',');
}

type Props = {
  open?: boolean;
  onOk?: () => void;
  onCancel?: () => void;
  orderNo?: string;
};

export default function PayModal(props: Props) {
  const [data, setData] = useState<OrderDetailResp | null>(null);
  const { userInfo } = useContext(UserContext);

  useEffect(() => {
    if (props.orderNo) {
      api.orderDetail({ orderNo: props.orderNo }).then((res) => {
        setData(res.result || null);
      });
    } else {
      setData(null);
    }
  }, [props.orderNo]);

  return (
    <>
      <Modal
        width={420}
        open={props.open}
        onOk={props.onOk}
        onCancel={props.onCancel}
        title={
          <>
            <div style={{ textAlign: 'center' }} className={styles.font5}>
              租赁付款
            </div>
          </>
        }
        footer={
          <Button type='primary' className={styles.btn} style={{ marginTop: 43 }}>
            立即付款
          </Button>
        }
      >
        <div
          style={{ marginTop: 16, marginBottom: 34, textAlign: 'center' }}
          className={styles.font1}
        >
          {formatNumber(data?.shouldPay || 0)}{' '}
          <span
            className={styles.font2}
            style={{ transform: 'translateY(-3px)', display: 'inline-block' }}
          >
            元
          </span>
        </div>
        <Row gutter={[0, 16]}>
          <Col span={6} className={styles.font3}>
            云仓账号
          </Col>
          <Col span={18} className={styles.font4}>
            UID{userInfo?.uid}
          </Col>
          <Col span={6} className={styles.font3}>
            付款方式
          </Col>
          <Col span={18} className={styles.font4}>
            充值余额（可用:¥2000000）
          </Col>
        </Row>
      </Modal>
    </>
  );
}
