import request, { Response } from '~/api/request';

export interface CooperationApplyParams {
  applyName: string;
  applyPhone: string;
  remark?: string;
  cooperationTagId: number;
  attachmentList?: { type: number; url: string }[];
}

export interface GetTagIdResp {
  id: number;
  tagName: string;
  tagImg: string;
  tagDescription: string;
  createTime: string;
  tagRequire: string;
}

export default {
  // 申请加盟
  cooperationApply(params: CooperationApplyParams): Promise<Response<string>> {
    return request('/userapp/cooperation/apply', 'post', params);
  },
  // 加盟标签相关内容
  getTagById(params: { id: number }): Promise<Response<GetTagIdResp>> {
    return request('/userapp/cooperation/getTagById', 'get', params);
  },
};
