import React, { useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import styled from 'styled-components';
import LayoutView from '@/components/layout';
import { RootState } from '@/store';
import { setGlobalData } from '@/store/module/globalData';
import { SystemState } from '@/store/module/system';

const MineAccountPage = () => {
  // store
  const dispatch = useDispatch();
  // system
  const system = useSelector((state: RootState) => state.system) as SystemState;
  // 页面加载
  useEffect(() => {
    if (!system?.token) {
      dispatch(
        setGlobalData({
          loginModalVisible: true,
          loginModalBack: true,
        }),
      );
    }
  }, []);
  return (
    <LayoutView>
      <MineAccountWrap>
        <div>MineAccountPage</div>
      </MineAccountWrap>
    </LayoutView>
  );
};

export default MineAccountPage;
// 样式
const MineAccountWrap = styled.div`
  position: relative;
  max-width: 1190px;
  box-sizing: border-box;
  padding: 2rem 0 0 0;
  margin: 0 auto;
`;
