import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import { Button } from 'antd';
import { useRouter } from 'next/router';
import { useDispatch } from 'react-redux';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { ListBrandInfoType } from '@/api/interface/home';
import { setGlobalData } from '@/store/module/globalData';

type ListType = InterListType<ListBrandInfoType>;

const HomeTabView05 = () => {
  // 导航钩子
  const router = useRouter();
  // store
  const dispatch = useDispatch();
  // 列表数据
  const [tabList, setTabList] = useState<ListType>([]);
  // 获取云享商城分类
  const getListBrandInfo = async () => {
    const res = await HomeAPI.getListBrandInfo({
      pageNo: 1,
      pageSize: 999,
    });
    if (res && res.code === '200') {
      setTabList(res.result?.list?.filter((i) => i.modeInfoList?.length));
      // console.log('获取云享商城分类 --->', res);
    }
  };
  // 跳转一级分类详情
  const handleMain = (i: ListType[0]) => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: true,
      }),
    );
    router.push(`/rent/${i?.id}`).then();
  };
  // 跳转二级分类详情
  const handleSecond = (i: ListType[0], n: ListType[0]['modeInfoList'][0]) => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: true,
      }),
    );
    router.push(`/rent/${i?.id}/${n?.id}`).then();
  };
  // 跳转更多
  const handleMore = async () => {
    await router.push('/rent');
  };
  // 组件挂载
  useEffect(() => {
    getListBrandInfo().then();
  }, []);
  return (
    <HomeTabWrap05 className="animate__animated animate__fast animate__fadeIn">
      <div className="tab-title flex-between w-full">
        <div className="label flex-start ">
          <div className="title select-none">设备租赁</div>
          <div
            className="action flex-end cursor-pointer text-primary"
            onClick={handleMore}
          >
            <div className="text">更多</div>
            <RightOutlined className="text-primary" style={{ fontSize: 10 }} />
          </div>
        </div>
      </div>
      <div className="tab-list">
        {tabList.map((i, j) => (
          <div key={j}>
            <div className={'tab-little flex-start'}>
              <div className="title-name" onClick={() => handleMain(i)}>
                {i.brandName}
              </div>
            </div>
            <div className="tab-list flex-start">
              {i.modeInfoList?.map((n, m) => (
                <Button
                  type={'link'}
                  key={m}
                  className="list-item"
                  onClick={() => handleSecond(i, n)}
                >
                  {n.modeName}
                </Button>
              ))}
            </div>
          </div>
        ))}
      </div>
    </HomeTabWrap05>
  );
};

export default HomeTabView05;
// 样式
const HomeTabWrap05 = styled.div`
  position: relative;
  box-sizing: border-box;
  padding-top: 1.58rem;
  width: 100%;
  .tab-title {
    margin-bottom: 1.33rem;
    .label {
      align-items: center;
      .title {
        font-weight: 600;
        font-size: 1.33rem;
        color: #333333;
        margin-right: 2rem;
      }
      .action {
        font-weight: 500;
        font-size: 0.78rem;
        color: #ff552d;
        margin-top: 0.15rem;
        .text {
          margin-right: 0.25rem;
        }
      }
    }
  }
  .tab-list {
    position: relative;
    width: 100%;
    flex-wrap: wrap;
    margin-bottom: 1rem;
    .list-item {
      color: #666666;
      font-weight: 500;
    }
  }
`;
