import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { FlyerAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { queryCurriculumInfoListType } from '@/api/interface/flyer';

// 列表类型
type ListType = InterListType<queryCurriculumInfoListType>;

const HomeCourseView: React.FC = () => {
  // 路由钩子
  const router = useRouter();
  // 课程列表
  const [courseList, setCourseList] = useState<ListType>([]);
  // 获取热门课程
  const getCurriculumInfoList = async () => {
    const res = await FlyerAPI.queryCurriculumInfoList({
      pageSize: 2,
      pageNo: 1,
      isHot: 1,
    });
    if (res && res.code === '200') {
      const list = res.result?.list || [];
      setCourseList(list);
    }
  };
  // 跳转详情
  const handleDetail = (detail: ListType[0]) => {
    router.push(`/course/detail?id=${detail.id}`).then();
  };
  // 组件挂载
  useEffect(() => {
    getCurriculumInfoList().then();
  }, []);
  return (
    <HomeCourseWrap>
      <div className="course-head flex-between">
        <div className="label flex-start select-none">
          <img
            className="icon"
            src="https://file.iuav.com/file/sharefly-home-comp-icon-02.png"
            alt="热门课程"
          />
          <div className="text">热门课程</div>
        </div>
        <div className="more flex-end cursor-pointer">
          <div className="text">更多</div>
          <RightOutlined />
        </div>
      </div>
      <div className="course-list flex-start">
        {courseList?.map((i, j) => (
          <div
            key={j}
            className="list-item cursor-pointer list-none"
            onClick={() => handleDetail(i)}
          >
            <img
              className="image"
              src={`${i?.surfaceUrl}?x-oss-process=image/quality,q_10`}
              alt={i?.curriculumName}
            />
          </div>
        ))}
      </div>
    </HomeCourseWrap>
  );
};

export default HomeCourseView;
// 样式
const HomeCourseWrap = styled.div`
  position: relative;
  width: 100%;
  margin: 0 0 1rem 0;
  box-sizing: border-box;
  .course-head {
    position: relative;
    box-sizing: border-box;
    width: 100%;
    margin-bottom: 0.67rem;
    .label {
      .icon {
        width: 2rem;
        height: 2rem;
      }
      .text {
        font-weight: 550;
        font-size: 1rem;
        color: #333333;
      }
    }
    .more {
      color: #ff552d;
    }
  }
  .course-list {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    .list-item {
      position: relative;
      box-sizing: border-box;
      width: calc((100% - 1.11rem) / 2);
      &:hover {
        filter: brightness(0.96);
      }
      &:not(:nth-child(2n)) {
        margin-right: 1.11rem;
      }
      .image {
        width: 100%;
        height: 6.67rem;
        border-radius: 0.44rem;
        object-fit: cover;
      }
    }
  }
`;
