import React, { useEffect, useState } from 'react';
import { Carousel } from 'antd';
import styled from 'styled-components';
import { InterDataType } from '@/api/interface';
import { ListBannerImgType } from '@/api/interface/home';
import QrcodePopover from '@/components/qrcodePopover';
import { getBannerList } from '@/utils';

// 列表类型
type ListType = InterDataType<ListBannerImgType>;

const HomeBannerView: React.FC = () => {
  // 轮播图数据
  const [bannerList, setBannerList] = useState<ListType>();
  // 获取轮播图数据
  const getBannerImageList = async () => {
    const res = await getBannerList('HOME_BANNER');
    setBannerList(res || []);
    // console.log('轮播图 --->', res);
  };
  // 转换轮播图链接
  const getBannerUrl = (url: string) => {
    // 判断是否有参数
    const index = url.indexOf('?');
    if (index !== -1) {
      return {
        url: url?.substring(1, index),
        query: url?.substring(index + 1),
      };
    }
    return {
      url: url?.substring(1),
    };
  };
  // 组件挂载
  useEffect(() => {
    getBannerImageList().then();
  }, []);
  return (
    <HomeBannerWrap>
      <Carousel autoplay autoplaySpeed={5000}>
        {bannerList?.map((i, j) => (
          <div className="swiper-item" key={j}>
            <QrcodePopover
              path={getBannerUrl(i?.bannerUrl)?.url}
              scene={getBannerUrl(i?.bannerUrl)?.query}
            >
              <img className="image" src={i?.bannerImg} alt={i?.bannerName} />
            </QrcodePopover>
          </div>
        ))}
      </Carousel>
    </HomeBannerWrap>
  );
};

export default HomeBannerView;
// 样式
const HomeBannerWrap = styled.div`
  position: relative;
  width: 98%;
  box-sizing: border-box;
  margin: 0 auto 1rem;
  .swiper-item {
    position: relative;
    width: 100%;
    height: 8.17rem;
    cursor: pointer;
    .image {
      width: 100%;
      height: 100%;
    }
    &:hover {
      filter: brightness(0.96);
    }
  }
`;
