import { FC, useEffect } from 'react';

const MapContainer: FC<{
  list: { lat: number; lon: number; name: string }[];
  center?: [number, number];
}> = ({ list, center }) => {
  // 地图实例
  let map: any = null;
  // 高德地图
  let AmapRef: any = null;
  // const [amapRef, setAmapRef] = useState<any>();

  // 添加点数据 entry
  const addMarkerEntry = ({
    lon,
    lat,
    name,
  }: {
    lon: any;
    lat: any;
    name: string;
  }) => {
    // console.log('执行到此处 ===>', AmapRef);
    if (!AmapRef) return;
    const icons = new AmapRef.Icon({
      size: new AmapRef.Size(60, 60), // 图标尺寸
      image: '/assets/image/home/home-map-marker.png', // Icon的图像
      imageSize: new AmapRef.Size(60, 60), // 根据所设置的大小拉伸或压缩图片
    });
    // eslint-disable-next-line consistent-return
    return new AmapRef.Marker({
      position: new AmapRef.LngLat(lon, lat),
      offset: new AmapRef.Pixel(-10, -10),
      icon: icons, // 添加 Icon 实例
      title: name,
      zoom: 13,
    });
  };
  // 设置地图点事件
  const handleMarkerSet = () => {
    try {
      const markers = list.map((i) => addMarkerEntry(i));
      map?.add(markers);
      // 自适应显示多个点位
      map?.setFitView();
    } catch (e) {
      // eslint-disable-next-line no-console
      // console.log('地图加载失败 ===>', e, AmapRef);
    }
  };
  // 组件挂载
  useEffect(() => {
    if (typeof window !== 'undefined') {
      import('@amap/amap-jsapi-loader').then((AMapLoader) => {
        AMapLoader.load({
          key: '87b424e68754efc3ba9d11ae07475091', // 申请好的Web端开发者Key，首次调用 load 时必填
          version: '2.0', // 指定要加载的 JSAPI 的版本，缺省时默认为 1.4.15
          plugins: [], // 需要使用的的插件列表，如比例尺'AMap.Scale'等
        })
          .then((AMap) => {
            // eslint-disable-next-line react-hooks/exhaustive-deps
            AmapRef = AMap;
            // setAmapRef(AMap);
            // eslint-disable-next-line react-hooks/exhaustive-deps
            map = new AMap.Map('container', {
              // 设置地图容器id
              viewMode: '3D', // 是否为3D地图模式
              zoom: 10, // 初始化地图级别
              center: center || [119.96043, 30.04885], // 初始化地图中心点位置
            });
            // 用户定位
            map.plugin('AMap.Geolocation', () => {
              const geolocation = new AMap.Geolocation({
                enableHighAccuracy: true, // 是否使用高精度定位，默认:true
                timeout: 10000, // 超过10秒后停止定位，默认：5s
                position: 'RB', // 定位按钮的停靠位置
                offset: [10, 55], // 定位按钮与设置的停靠位置的偏移量，默认：[10, 20]
                zoomToAccuracy: true, // 定位成功后是否自动调整地图视野到定位点
              });
              map.addControl(geolocation);
              // geolocation.getCurrentPosition((status: string, result: any) => {
              //   console.log(result);
              // if (status == 'complete') {
              //   onComplete(result);
              // } else {
              //   onError(result);
              // }
              // });
            });
            // 如果列表没有数据则停止执行
            if (!list.length) return;
            // 设置地图点
            handleMarkerSet();
          })
          .catch((e) => {
            // eslint-disable-next-line no-console
            console.log('地图加载失败 ===>', e);
          });
      });
    }
    return () => {
      try {
        map?.destroy();
      } catch (e) {
        // eslint-disable-next-line no-console
        console.log('地图销毁失败 ===>', e);
      }
    };
  }, [list, center]);
  return (
    <div
      id="container"
      className={'animate__animated animate__fast animate__fadeIn container'}
      style={{
        height: '100%',
        padding: 0,
        margin: 0,
        width: '100%',
        zIndex: 1,
      }}
    ></div>
  );
};
export default MapContainer;
