import React, { useEffect, useState } from 'react';
import { Button } from 'antd';
import { useRouter } from 'next/router';
import { useDispatch } from 'react-redux';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterDataType } from '@/api/interface';
import { AppCategoryInfoType } from '@/api/interface/home';
import { setGlobalData } from '@/store/module/globalData';

// 列表类型
type ListType = InterDataType<AppCategoryInfoType>;

const TabView01 = () => {
  // 导航钩子
  const router = useRouter();
  // store
  const dispatch = useDispatch();
  // 列表数据
  const [tabList, setTabList] = useState<ListType>([]);
  // 获取云享商城分类
  const getAppCategoryInfo = async () => {
    const res = await HomeAPI.appCategoryInfo({
      type: 4,
    });
    if (res && res.code === '200') {
      setTabList(res.result?.filter((i) => i.subDTOList?.length));
      // console.log('获取云享商城分类 --->', tabList);
    }
  };
  // 跳转一级分类详情
  const handleMain = (i: ListType[0]) => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: true,
      }),
    );
    router.push(`/mall/${i?.id}`).then();
  };
  // 跳转二级分类详情
  const handleSecond = (i: ListType[0], n: ListType[0]['subDTOList'][0]) => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: true,
      }),
    );
    router.push(`/mall/${i?.id}/${n?.id}`).then();
  };
  // 组件挂载
  useEffect(() => {
    getAppCategoryInfo().then();
  }, []);
  return (
    <TabViewWrap className="animate__animated animate__fast animate__fadeIn">
      {tabList.map((i, j) => (
        <div className="tab-item align-start flex" key={j}>
          <div className={'tab-little flex-start'}>
            {!!i.icon && (
              <img src={i.icon} alt={i.name} className="title-image" />
            )}
            <Button
              type={'link'}
              className="title-name"
              onClick={() => handleMain(i)}
            >
              {i.name}
            </Button>
          </div>
          <div className="tab-list flex-start">
            {i.subDTOList?.map((n, m) => (
              <Button
                type={'link'}
                key={m}
                className="list-item"
                onClick={() => handleSecond(i, n)}
              >
                {n.name}
              </Button>
            ))}
          </div>
        </div>
      ))}
    </TabViewWrap>
  );
};
// 样式
const TabViewWrap = styled.div`
  position: relative;
  width: 100%;
  box-sizing: border-box;
  padding: 0.79rem 1.58rem;
  //background: lightyellow;
  .tab-item {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    margin-bottom: 0.48rem;
    padding-bottom: 0.48rem;
    border-bottom: 0.02rem solid #ededed;
    &:last-child {
      border: none;
    }
  }
  .tab-little {
    position: relative;
    box-sizing: border-box;
    //padding-bottom: 0.68rem;
    //border-bottom: 0.02rem solid #ededed;
    //margin-bottom: 0.5rem;
    .title-image {
      width: 1.68rem;
      height: 1.68rem;
      margin-right: 0.5rem;
    }
    .title-name {
      font-size: 0.78rem;
      font-weight: 550;
      color: #333333;
      padding: 0;
    }
  }
  .tab-list {
    position: relative;
    flex-wrap: wrap;
    max-width: calc(100% - 6rem);
    transform: translateY(0.86px);
    //height: 1.58rem;
    //overflow: hidden;
    //margin-bottom: 1rem;
    //transform: translateX(-10px);
    .list-item {
      color: #666666;
      font-weight: 500;
      padding-right: 0;
    }
  }
  @media (prefers-color-scheme: dark) {
    .tab-little {
      .title-name {
        color: #fff;
      }
    }
    .tab-list {
      .list-item {
        color: #999;
      }
    }
  }
`;
export default TabView01;
