import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import { Empty, Pagination } from 'antd';
import { useRouter } from 'next/router';
import { useDispatch } from 'react-redux';
import styled from 'styled-components';
import { InterListType, InterReqType } from '@/api/interface';
import { QueryCurriculumInfoListType } from '@/api/interface/course';
import { CourseAPI } from '@/api/modules/course';
import CourseListItem from '@/components/courseItem';

// 列表类型
type ListType = InterListType<QueryCurriculumInfoListType>;
// 请求参数类型
type ReqType = InterReqType<QueryCurriculumInfoListType>;

const HomeTabView03: React.FC = () => {
  // 导航钩子
  const router = useRouter();
  // store
  const dispatch = useDispatch();
  // 分页数据
  const [pagination, setPagination] = useState({
    pageNo: 1,
    pageSize: 8,
    totalCount: 0,
  });
  // 列表数据
  const [dataList, setDataList] = useState<ListType>([]);
  const handleMore = async () => {
    await router.push('/course');
  };
  // 组件挂载
  useEffect(() => {
    getDataList({}).then();
  }, []);
  // 获取课程列表
  const getDataList = async (data: ReqType) => {
    const res = await CourseAPI.getCourseVideoList({
      pageNo: pagination.pageNo,
      pageSize: pagination.pageSize,
      ...data,
    });
    if (res && res.code === '200') {
      console.log('获取商品列表 --->', res);
      const { list, totalCount, pageNo, pageSize } = res.result;
      setDataList(list || []);
      setPagination({
        ...pagination,
        totalCount,
        pageNo,
        pageSize,
      });
    }
  };
  // 翻页回调
  const handlePageChange = async (pageNo: number, pageSize: number) => {
    await getDataList({ pageNo, pageSize });
  };
  return (
    <HomeTabWrap04 className="animate__animated animate__fast animate__fadeIn">
      <div className="tab-title flex-between w-full">
        <div className="label flex-start ">
          <div className="title select-none">技能课堂</div>
          <div
            className="action flex-end cursor-pointer text-primary"
            onClick={handleMore}
          >
            <div className="text">更多</div>
            <RightOutlined className="text-primary" style={{ fontSize: 10 }} />
          </div>
        </div>
        <Pagination
          showSizeChanger={false}
          onChange={handlePageChange}
          defaultPageSize={pagination.pageSize}
          current={pagination.pageNo}
          total={pagination.totalCount}
        />
      </div>
      <div className="tab-list flex-start w-full">
        {dataList?.length ? (
          dataList?.map((i, j) => <CourseListItem key={j} detail={i} />)
        ) : (
          <div className="list-empty flex-center h-24 w-full">
            <Empty />
          </div>
        )}
      </div>
    </HomeTabWrap04>
  );
};

export default HomeTabView03;
// 样式
const HomeTabWrap04 = styled.div`
  position: relative;
  box-sizing: border-box;
  padding-top: 1.58rem;
  width: 100%;
  .tab-title {
    margin-bottom: 1.33rem;
    .label {
      align-items: center;
      .title {
        font-weight: 600;
        font-size: 1.33rem;
        color: #333333;
        margin-right: 2rem;
      }
      .action {
        font-weight: 500;
        font-size: 0.78rem;
        color: #ff552d;
        margin-top: 0.15rem;
        .text {
          margin-right: 0.25rem;
        }
      }
    }
  }
  .tab-list {
    .tab-item {
      position: relative;
      width: 100%;
      box-sizing: border-box;
      margin-bottom: 0.48rem;
      padding-bottom: 0.48rem;
      border-bottom: 0.02rem solid #ededed;
      &:last-child {
        border: none;
      }
    }
    .tab-little {
      position: relative;
      box-sizing: border-box;
      //padding-bottom: 0.68rem;
      //border-bottom: 0.02rem solid #ededed;
      //margin-bottom: 0.5rem;
      .title-image {
        width: 1.68rem;
        height: 1.68rem;
        margin-right: 0.5rem;
      }
      .title-name {
        font-size: 0.78rem;
        font-weight: 550;
        color: #333333;
        padding: 0;
      }
    }
    .tab-list {
      position: relative;
      flex-wrap: wrap;
      max-width: calc(100% - 6rem);
      transform: translateY(0.86px);
      //height: 1.58rem;
      //overflow: hidden;
      //margin-bottom: 1rem;
      //transform: translateX(-10px);
      .list-item {
        color: #666666;
        font-weight: 500;
        padding-right: 0;
      }
    }
    @media (prefers-color-scheme: dark) {
      .tab-little {
        .title-name {
          color: #fff;
        }
      }
      .tab-list {
        .list-item {
          color: #999;
        }
      }
    }
  }
`;
