import React from 'react';
import {
  CarryOutOutlined,
  ShopOutlined,
  TeamOutlined,
} from '@ant-design/icons';
import styled from 'styled-components';

const HomeBottomView = () => {
  // 标签列表
  const bottomList = [
    {
      title: '无人机垂直领域综合服务平台',
      icon: <CarryOutOutlined style={{ fontSize: 32, color: '#333' }} />,
    },
    {
      title: '10W+无人机爱好者的学习交流平台',
      icon: <TeamOutlined style={{ fontSize: 32, color: '#333' }} />,
    },
    {
      title: '汇聚众多无人机行业优质商家',
      icon: <ShopOutlined style={{ fontSize: 32, color: '#333' }} />,
    },
  ];
  return (
    <HomeBottomWrap>
      {bottomList?.map((i, j) => (
        <div className="bottom-item" key={j}>
          {i?.icon}
          <div className="item-text">{i?.title}</div>
        </div>
      ))}
    </HomeBottomWrap>
  );
};
export const HomeBottomWrap = styled.div`
  position: relative;
  width: 100%;
  height: 12.25rem;
  display: flex;
  justify-content: space-between;
  align-items: center;
  .bottom-item {
    position: relative;
    display: flex;
    align-items: center;
    justify-content: flex-start;
    flex-direction: column;
    .item-text {
      font-size: 13px;
      font-weight: 500;
      color: #666666;
      margin-top: 0.67rem;
    }
  }
`;
export default HomeBottomView;
