import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { HomeAPI, ServiceAPI } from '@/api';
import { InterDataType, InterListType } from '@/api/interface';
import { AppPublishListType } from '@/api/interface/home';
import { GetIndustryListPagesType } from '@/api/interface/service';
import QrcodePopover from '@/components/qrcodePopover';
import ServiceTaskItem from '@/pages/service/task/comp/_serviceTaskItem';

// 列表类型
type ListType = InterDataType<AppPublishListType>;
// 行业类型
type IndustryType = InterListType<GetIndustryListPagesType>;

const HomeTaskView = () => {
  // 路由钩子
  const router = useRouter();
  // 实时订单列表
  const [requireList, setRequireList] = useState<ListType>([]);
  // 获取实时订单列表
  const getAppPublishList = async () => {
    const res = await HomeAPI.appPublishList({
      isNewRequirements: true,
    });
    if (res && res.code === '200') {
      const list = res.result || [];
      // console.log('订单列表 --->', list?.slice(0, 5));
      setRequireList(list?.slice(0, 5));
    }
  };
  // 行业列表
  const [industryList, setIndustryList] = useState<IndustryType>([]);
  // 获取各个目录及分类信息
  const getIndustryListPages = async () => {
    const res = await ServiceAPI.getIndustryListPages({
      pageNo: 1,
      pageSize: 999,
    });
    if (res && res.code === '200') {
      setIndustryList(res?.result?.list || []);
    }
  };
  // 跳转更多
  const handleMore = async () => {
    await router.push('/service/task');
  };
  // componentDidMount
  useEffect(() => {
    Promise.all([getAppPublishList(), getIndustryListPages()]).then();
  }, []);
  return (
    <HomeTaskWrap>
      <div className="tab-title flex-between">
        <div className="label select-none">服务订单</div>
        <div
          className="action flex-end cursor-pointer text-primary"
          onClick={handleMore}
        >
          <div className="text">更多</div>
          <RightOutlined className="text-primary" style={{ fontSize: 10 }} />
        </div>
      </div>
      <div className="tab-list">
        {requireList?.map((i, j) => (
          <QrcodePopover
            key={j}
            path={'page-order/order-flyer/index'}
            scene={`id=${i?.id}`}
          >
            <ServiceTaskItem
              detail={i}
              industryList={industryList}
              width={'100%'}
            />
          </QrcodePopover>
        ))}
      </div>
    </HomeTaskWrap>
  );
};

export default HomeTaskView;
export const HomeTaskWrap = styled.div`
  position: relative;
  width: 30%;
  box-sizing: border-box;
  padding-top: 1.58rem;
  .tab-title {
    margin-bottom: 1.33rem;
    .label {
      font-weight: 600;
      font-size: 1.33rem;
      color: #333333;
      margin-right: 2rem;
    }
    .action {
      font-weight: 500;
      font-size: 0.78rem;
      color: #ff552d;
      .text {
        margin-right: 0.25rem;
      }
    }
  }
  .tab-list {
    position: relative;
    width: 100%;
    .list-item {
      width: 100%;
      height: 6.78rem;
      //background: #ffffff;
      box-shadow: 0 0.22rem 0.58rem 0 rgba(56, 116, 205, 0.04);
      margin-bottom: 0.72rem;
      background: lightblue;
    }
  }
`;
