import { InterFunction } from '@/api/interface';

// 获取二维码
export type GetAppletQRCode = InterFunction<
  // 入参
  {
    page: string;
    scene: string;
  },
  // 出参
  string
>;
// 查询登录信息
export type GetLoginInfo = InterFunction<
  {
    randomLoginCode: string;
  },
  {
    token: string;
    openId: string;
    userAccountId: number;
    accountNo: null;
    portType: number;
    uid: string;
    phoneNum: string;
    userName: string;
    nickName: string;
    companyInfoVO: null;
    roleInfo: null;
    appUserAccountId: null;
  }
>;
// 获取用户信息
export type GetAccountInfo = InterFunction<
  {},
  {
    accountStatus: number;
    accountType: number;
    companyAuthStatus: number;
    email: string;
    id: number;
    nickName: string;
    phoneNum: string;
    portType: number;
    source: number;
    uid: string;
    userImg: string;
    userName: string;
    userSex: number;
    realNameAuthStatus: number;
    auditStatus: number;
    totalPoints: number;
    xzAuthStatus: number;
    cooperationTagVOS: {
      createTime: string;
      id: number;
      tagDescription: string;
      tagImg: string;
      tagName: string;
      tagRequire: string;
    }[];
    coverPicture: string;
    districtChildId: number;
    region: string;
    briefIntroduction: string;
    companyInfoVO: {
      address: string;
      backImg: string;
      backUserAccountId: number;
      brandLogo: string;
      brandName: string;
      companyName: string;
      companyType: number;
      companyUserName: string;
      content: string;
      creditCode: string;
      distance: number;
      fullName: string;
      id: number;
      lat: number;
      leader: number;
      licenseImg: string;
      lon: number;
      phoneNum: number;
      remark: string;
      score: string;
      userAccountId: number;
    };
    createTime: string;
  }
>;
// 测试-手机号登录
export type TestPhoneLogin = InterFunction<
  {
    phone: string;
  },
  {
    authStatus: null;
    nickName: string;
    phoneNum: string;
    portType: number;
    sessionKey: null;
    token: string;
    uid: string;
    userAccountId: number;
  }
>;
// 获取修改手机获取验证码
export type GetVerifyCodeType = InterFunction<
  {
    userAccountId: number;
    phoneNum: string;
  },
  {}
>;
// web注册获取手机号验证码
export type GetVerifyCodeAuthType = InterFunction<
  {
    phoneNum: string;
  },
  {}
>;
// web端注册
export type WebRegisterType = InterFunction<
  {
    code: string;
    password: string;
    phoneNum: string;
  },
  {}
>;
// web端账号密码登录
export type WebLoginType = InterFunction<
  {
    accountNo: string;
    passWord: string;
  },
  {
    nickName: string;
    phoneNum: string;
    token: string;
    userAccountId: number;
  }
>;
// 获取图片-小程序
export type ListBannerImg = InterFunction<
  { moduleCode: string },
  {
    bannerImg: string;
    bannerName: string;
    bannerPoster: null;
    bannerType: number;
    bannerUrl: string;
    createTime: string;
    deleted: number;
    detailInfo: null;
    endTime: null;
    goodsId: null;
    id: number;
    moduleId: number;
    sort: number;
    startTime: null;
    textContent: string;
    using: number;
  }[]
>;
