/** @type {import('next').NextConfig} */
let distDir = ".next"; //默认输出目录

if (process.env.NODE_ENV === "production") {
  //生产环境用另一个目录构建，防止与dev冲突
  distDir = ".next";
}

const nextConfig = {
  distDir,
  reactStrictMode: true,
  transpilePackages: ["antd"],
  output: "standalone",
  compiler: {
    styledComponents: true,
  },
  redirects() {
    return [
      {
        source: "/",
        destination: "/home",
        permanent: true,
      },
    ];
  },
  async rewrites() {
    return [
      {
        source: "/local/:path*",
        destination: "https://iuav.mmcuav.cn/:path*",
      },
    ];
  },
  images: {
    remotePatterns: [
      {
        protocol: "http",
        hostname: "**",
      },
      {
        protocol: "https",
        hostname: "**",
      },
    ],
  },
  pageExtensions: ["page.tsx", "page.ts", "page.jsx", "page.js"],
};

module.exports = nextConfig;
