import request, { Response } from '~/api/request';

export interface ListPublishPageParams {
  cityCode?: number;
  date?: string;
  districtCode?: number;
  pageNo: number;
  pageSize: number;
  provinceCode?: number;
}

export interface ListPublishPageResp {
  pageNo: number;
  pageSize: number;
  list: Item[];
  totalCount: number;
  totalPage: number;
}

export interface Item {
  id: number;
  requirementTypeId: number;
  userAccountId: number;
  publishName: string;
  publishPhone: string;
  requireDescription: string;
  solved?: 0 | 1;
  createTime: string;
  updateTime?: string;
}

export interface SolveRequireParams {
  requirementsInfoId: number, //需求id
  userAccountId: number //用户id
}


export default {
  /**
   * 需求发布列表
   * @param params 
   * @returns 
   */
  listPublishPage(params: ListPublishPageParams, options = {}): Promise<Response<ListPublishPageResp>> {
    return request('/release/requirements/listPublishPage', 'post', params, options);
  },
  /**
   * 需求已解决
   * @param params 
   * @returns 
   */
  solveRequire(params: SolveRequireParams): Promise<Response<null>>{
    return request('/release/requirements/solveRequire', 'get', params);
  }
}