import React, { createContext, Dispatch, SetStateAction, useEffect, useState } from "react";
import api, { UserInfoResp } from "~/api";

export const UserContext = createContext<{
  testLogin: () => void;
  logout: () => void;
  userInfo: UserInfoResp | null;
  setUserInfo: Dispatch<SetStateAction<UserInfoResp | null>>;
}>({
  testLogin() {},
  logout() {},
  userInfo: null,
  setUserInfo() {},
});

type Props = {
  children: React.ReactNode;
};
const UserProvider = ({ children }: Props) => {
  const [userInfo, setUserInfo] = useState<UserInfoResp | null>(null);

  useEffect(() => {
    try {
      setUserInfo(JSON.parse(window.localStorage.getItem("userInfo") || ""));
    } catch (e) {}
  }, []);

  useEffect(() => {
    localStorage.setItem("userInfo", JSON.stringify(userInfo || ""));
  }, [userInfo]);

  //测试登录
  function testLogin() {
    api.testAppletLogin().then((res) => {
      if (res.code == "200") {
        window.localStorage.setItem("token", res.result?.token || "");
        api.userInfo().then((res) => {
          setUserInfo(res.result || null);
        });
      }
    });
  }

  //登出
  function logout() {
    localStorage.setItem("token", "");
    setUserInfo(null);
  }

  return (
    <UserContext.Provider value={{ userInfo, setUserInfo, testLogin, logout }}>
      {children}
    </UserContext.Provider>
  );
};

export default UserProvider;
