import request, { Response } from '~/api/request';

export interface GetWebDeviceDetailParams {
  buyNum: number;
  directoryId: number;
  goodsInfoId: number;
  mallSpecIds: number[];
  remark?: string;
  userAddressId: number;
}

export interface WareImgsType {
  id: number;
  imgUrl: string;
  imgType: number;
}

export interface UserAddress {
  id: number;
  takeName: string;
  takePhone: string;
  takeRegion: string;
  takeAddress: string;
  type: number;
}

export interface GetOrderForGoods {
  realityAmount: number;
  orderNo: string;
}

export default {
  // web-地址管理-查询用户地址列表-条件查询
  listUserAddress: (params: {}): Promise<Response<UserAddress[]>> => {
    return request('/oms/user-address/selectList', 'POST', params);
  },
  // web-产品商城-下单
  FeignAddLease: (params: GetWebDeviceDetailParams): Promise<Response<GetOrderForGoods>> => {
    return request('/oms/app-order/commitMallOrder', 'post', params);
  },
  // web-产品商城-订单支付
  OrderPayment: (params: { orderNo: string }): Promise<Response<GetOrderForGoods>> => {
    return request(`/payment/repocash/orderPayment`, 'get', params);
  },
};
