import React, { useEffect, useState } from 'react';

import Image from 'next/image';

import kh from './assets/kh.jpg';
import { Box } from './styled';

interface MockExamType {}

export default function MockExam() {
  const [list, setList] = useState<Array<MockExamType>>();

  useEffect(() => {
    setList([{}, {}, {}, {}, {}, {}]);
  }, []);
  return (
    <Box>
      <div className='content'>
        {list?.map((item, i) => (
          <div key={i} className='item'>
            <div className='img-box'>
              <Image src={kh.src} fill alt='#'></Image>
            </div>
            <div className='item-content'>
              <div className='top'>云飞手行业认证考核</div>
              <div className='bottom'>
                <div className='user-img'></div>
                <div className='application'>77人报名</div>
              </div>
            </div>
          </div>
        ))}
      </div>
    </Box>
  );
}
