import React, { useEffect, useState } from "react";
import { useRouter } from "next/router";
import { Pagination } from "antd";
import { Box } from "./styled";
import Layout from "~/components/layout";
import ContentBox from "~/components/contentBox";
import Filter, { FilterResult, AdapterResult } from "~/components/filter";
import Image from "next/image";
import api, { Device, Advertisement } from "./api";
// 此函数在构建时被调用
export async function getStaticProps() {
  //获取筛选数据，进行静态渲染
  return {
    props: {},
  };
}

type Props = {};

export default function EquipmentLeasing(props: Props) {
  const router = useRouter();
  const [productList, setProductList] = useState(
    Array<{ element: JSX.Element }>
  );
  const [rightProductList, setRightProductList] = useState(
    Array<{ element: JSX.Element }>
  );

  const leftDom = (item: Device) => {
    return (
      <div
        key={item.id}
        className="item"
        onClick={() => router.push(`/equipmentLeasing/detail/${item.id}`)}
      >
        <div className="item-top">
          <div className="item-top-image">
            <Image
              src={item.wareImgs[0].imgUrl}
              alt="error"
              width={116}
              height={116}
            />
          </div>
        </div>
        <div className="item-bottom">
          <div className="item-bottom-title" title={item.wareTitle}>
            {item.wareTitle}
          </div>
          <div className="item-bottom-price">
            <span className="money">¥{item.minRent}</span>
            <span className="unit">/天起</span>
          </div>
        </div>
      </div>
    );
  };

  const rightDom = (item: Advertisement) => {
    return (
      <div key={item.id} className="right-box-item right-item">
        <Image src={item.imageUrl} alt="error" width={270} height={422} />
      </div>
    );
  };

  const [filterResult, setFilterResult] = useState<AdapterResult>({}); //筛选结果
  const [count, setCount] = useState(0); //商品总数
  const [abort, setAbort] = useState<AbortController | null>(null); //请求中断
  const [pageParams, setPageParams] = useState({
    pageNo: 1,
    pageSize: 16,
  }); //分页器对象

  const onPageChange = (page: number, pageSize: number) => {
    setPageParams({
      ...pageParams,
      pageNo: page,
    });
  };

  useEffect(() => {
    //中断前一次列表请求
    abort?.abort();
    setAbort(new AbortController());
  }, [filterResult, pageParams]);

  //端口列表请求
  useEffect(() => {
    api
      .listPageDeviceInfo(
        {
          ...filterResult,
          ...pageParams,
          ...router.query,
        },
        {
          signal: abort?.signal,
        }
      )
      .then((res) => {
        setProductList(
          res.result?.list.map((item) => {
            return { element: leftDom(item) };
          }) || []
        );
        setCount(res.result?.totalCount || 0);
      });
  }, [abort]);

  const onFilterChange = (
    filterResult: FilterResult,
    adapterFilterResult: AdapterResult
  ) => {
    console.log("filterResult", filterResult, adapterFilterResult);
    setFilterResult(adapterFilterResult);
  };

  useEffect(() => {
    api.listAdvertisementInfo().then((res) => {
      setRightProductList(
        res.result?.map((item) => {
          return { element: rightDom(item) };
        }) || []
      );
    });
  }, []);

  useEffect(() => {
    if (router.query) {
      setFilterResult({ ...router.query });
    }
  }, [router]);
  return (
    <Layout>
      <Box>
        <Filter
          types={["地域", "设备类目", "设备品牌", "设备型号"]}
          showResultItem
          onChange={onFilterChange}
        ></Filter>
        <div style={{ paddingTop: 13 }}>
          <ContentBox
            boxIndex={4}
            leftcontentstyle={{
              width: "916px",
              margin: { top: 0, right: "12px", bottom: "12px", left: 0 },
            }}
            leftRenderDom={{
              columns: productList,
              pagination: (
                <div className="pagination-page">
                  <Pagination
                    current={pageParams.pageNo}
                    pageSize={pageParams.pageSize}
                    showSizeChanger={false}
                    showQuickJumper
                    total={count}
                    onChange={onPageChange}
                    hideOnSinglePage={true}
                    style={{ marginTop: 20 }}
                  />
                </div>
              ),
            }}
            rightRenderDom={{ columns: rightProductList }}
          />
        </div>
      </Box>
    </Layout>
  );
}
