import React, { useEffect, useState } from "react";
import { AutoComplete, Modal } from "antd";
import Image from "next/image";

type Props = {
  open: boolean;
  onCancel: () => void;
};

export default function LoginModal(props: Props) {
  useEffect(() => {
    if (props.open) {
      var obj = new window.WxLogin({
        self_redirect: true,
        id: "login_container",
        appid: "wx18b7883acd204278",
        scope: "snsapi_login",
        redirect_uri: encodeURIComponent("https://iuav.mmcuav.cn/"),
        state: "",
        style: "",
        href: "",
      });
    }
  }, [props.open]);

  return (
    <>
      <Modal
        open={props.open}
        onCancel={props.onCancel}
        width={400}
        footer={null}
      >
        <div
          style={{
            fontSize: 20,
            fontFamily: "MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI",
            fontWeight: "bold",
            color: "#000",
            marginTop: 17,
            marginBottom: 48,
            textAlign: "center",
          }}
        >
          欢迎来到云享飞
        </div>
        <div
          id="login_container"
          style={{ margin: "auto", display: "table" }}
        ></div>
        <div
          style={{
            marginTop: -120,
            marginBottom: 52,
            fontSize: 14,
            fontFamily: "MicrosoftYaHei",
            color: "#3E454D",
            textAlign: "center",
          }}
        >
          打开微信扫一扫
        </div>
      </Modal>
    </>
  );
}
