import request, { Response } from "~/api/request";

export interface DynamicListParams {
  pageNo: number,
  pageSize: number,
  userId: number
}

export interface Dynamic {
  userId: number;
  id: number;
  title: string;
  description: string;
  location: string;
  lat: number;
  lon: number;
  mediaVO: {
    picture: string[];
    videoUrl: string;
  };
  likesCount: number;
  commentCount: number;
  likes: boolean;
}

export interface DynamicListResp {
  pageNo: 1;
  pageSize: 10;
  list: Array<Dynamic>;
  totalCount: 0;
  totalPage: 0;
}

export default {
  /**
   * 论坛动态列表
   * @param params
   * @returns
   */
  dynamicList(params: DynamicListParams): Promise<Response<DynamicListResp>> {
    return request("/release/dynamic/dynamicList", "get", params);
  },
};
