import { Form, Input, Radio } from 'antd';
import './index.scss';

const GoodsInfo = () => {
  const qualityList = [
    {
      label: '全新',
      value: 0,
    },
    {
      label: '99新',
      value: 1,
    },
    {
      label: '95新',
      value: 2,
    },
    {
      label: '90新',
      value: 3,
    },
    {
      label: '80新',
      value: 4,
    },
  ];

  return (
    <div className='goods-info'>
      <div className='goods-info-title'>商品信息</div>
      <Form labelCol={{ span: 2 }} wrapperCol={{ span: 10 }}>
        <Form.Item label='商品标题'>
          <Input placeholder='请输入商品标题' />
        </Form.Item>
        <Form.Item label='商品卖点'>
          <Input placeholder='请输入商品卖点' />
        </Form.Item>
        <Form.Item label='商品成新'>
          <Radio.Group>
            {qualityList.map((v, index) => (
              <Radio value={v.value} key={index}>
                {v.label}
              </Radio>
            ))}
          </Radio.Group>
        </Form.Item>
        <Form.Item label='商品状态'>
          <Radio.Group>
            <Radio value={1}>上架</Radio>
            <Radio value={0}>下架</Radio>
          </Radio.Group>
        </Form.Item>
      </Form>
    </div>
  );
};
export default GoodsInfo;
