import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  pageCurrent: JSON.parse(localStorage.getItem('SXTB-ADMIN-PAGE-CURRENT') as string) || [],
};

export const pageSlice = createSlice({
  name: 'pageSlice',
  initialState,
  reducers: {
    SET_PAGE_CURRENT(state, action) {
      state.pageCurrent = action.payload;
      localStorage.setItem('SXTB-ADMIN-PAGE-CURRENT', JSON.stringify(action.payload));
    },
  },
});

export const { SET_PAGE_CURRENT } = pageSlice.actions;

export const Page = pageSlice.reducer;
