import { FC } from 'react';
import { Form, Input, Modal, ModalProps, Select } from 'antd';
import { Uploader } from '~/components/uploader';
import { UploadOutlined } from '@ant-design/icons';
// eslint-disable-next-line @typescript-eslint/no-empty-interface
interface selfProps {}

const AddOrEditTagModal: FC<ModalProps & selfProps> = ({ open, onCancel }) => {
  return (
    <Modal open={open} onCancel={onCancel} title='新建标签'>
      <Form labelCol={{ span: 4 }} wrapperCol={{ span: 16 }}>
        <Form.Item label='标签名称'>
          <Input placeholder='请输入标签名称' />
        </Form.Item>
        <Form.Item label='标签类型'>
          <Select placeholder='请选择标签类型'>
            <Select.Option>1111</Select.Option>
          </Select>
        </Form.Item>
        <Form.Item label='标签等级图标'>
          <Uploader fileUpload listType='picture-card'>
            <UploadOutlined />
          </Uploader>
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default AddOrEditTagModal;
