import React, { FC, useEffect } from 'react';
import { Form, InputNumber, Modal, ModalProps } from 'antd';
import { InterDataType } from '~/api/interface';
import { SignInListType } from '~/api/interface/activityManage';

// 参数
interface selfProps {
  data?: InterDataType<SignInListType>[0]['userContinuousCheckInVO'][0];
  onSubmit: (data: InterDataType<SignInListType>[0]['userContinuousCheckInVO'][0]) => void;
}
const AddOrEditModal: FC<ModalProps & selfProps> = ({ open, onCancel, title, data, onSubmit }) => {
  // 表单钩子
  const [editForm] = Form.useForm();
  // 提交数据
  const handleSubmit = async () => {
    const valid = await editForm.validateFields();
    if (!valid) return;
    onSubmit({
      ...data,
      ...valid,
    });
  };
  // 关闭弹窗
  const handleCancel = (e: React.MouseEvent<HTMLButtonElement, MouseEvent>) => {
    editForm.resetFields();
    onCancel?.(e);
  };
  // 组件挂载
  useEffect(() => {
    if (data) {
      editForm.setFieldsValue(data);
    } else {
      editForm.resetFields();
    }
    // console.log('组件挂载 --->', data);
  }, [open]);
  return (
    <Modal open={open} onCancel={(e) => handleCancel(e)} title={title} onOk={handleSubmit}>
      <Form labelCol={{ span: 6 }} wrapperCol={{ span: 16 }} form={editForm}>
        <Form.Item
          label='连续签到天数'
          name='numberOfDays'
          rules={[
            { required: true, message: '请输入连续签到天数' },
            { pattern: /^[0-9]*$/g, message: '请输入整数' },
          ]}
        >
          <InputNumber min={1} max={100} placeholder='请输入连续签到天数' addonAfter={'天'} />
        </Form.Item>
        <Form.Item
          label='奖励积分'
          name='bonusPoints'
          rules={[
            { required: true, message: '请输入奖励积分' },
            { pattern: /^[0-9]*$/g, message: '请输入整数' },
          ]}
        >
          <InputNumber min={1} max={10000} placeholder='请输入奖励积分' addonAfter={'积分'} />
        </Form.Item>
      </Form>
    </Modal>
  );
};
export default AddOrEditModal;
