import React from 'react';
import { Image } from 'antd';
import './index.scss';

// 参数类型
interface propsType {
  src: string;
  width?: number;
  height?: number;
  autoPlay?: boolean;
  loop?: boolean;
  controls?: boolean;
}

const Video: React.FC<propsType> = (
  props = {
    src: 'https://file.iuav.com/file/sharefly-logo-2024.png',
    width: 40,
    height: 40,
  },
) => {
  // 视频是否预览
  const [isPreview, setIsPreview] = React.useState<boolean>(false);
  return (
    <>
      <Image
        src={`${props?.src}?x-oss-process=video/snapshot,t_1000,f_jpg`}
        width={props?.width}
        height={props?.height}
        preview={false}
        onClick={() => {
          setIsPreview(true);
        }}
      />
      {isPreview && (
        <div className='video-preview'>
          <view className='preview-mask' onClick={() => setIsPreview(false)}></view>
          {/*<Button className='button' shape='circle' icon={<CloseOutlined />} />*/}
          {/* eslint-disable-next-line jsx-a11y/media-has-caption */}
          <video className='video' src={props?.src} autoPlay controls></video>
        </div>
      )}
    </>
  );
};

export default Video;
