import { InterFunction, InterItemFunction } from '~/api/interface';

//执照等级下拉
export type licenceGradeListType = InterFunction<any, { id: number; name: string }[]>;
//执照机型下拉
export type licenceModelsListType = InterFunction<any, { id: number; name: string }[]>;
//规模下拉
export type licenceScaleList = InterFunction<any, { id: number; name: string }[]>;
//执照类型下拉
export type licenceTypeListType = InterFunction<any, { id: number; name: string }[]>;
//机构列表
export type listOrgPageType = InterItemFunction<
  {
    statTime?: string;
    endTime?: string;
    gradeId?: number;
    modelsId?: number;
    name?: string;
    region?: number;
    typeId?: number;
    id?: number;
  },
  {
    auxiliaryPicture: string;
    description: string;
    detail: string;
    detailedAddress: string;
    id: number;
    latitude: number;
    longitude: number;
    mainImage: string;
    name: string;
    programsDOList: Array<{
      gradeId: number;
      gradeName: number;
      id: number;
      mainImage: string;
      modelsId: number;
      modelsName: number;
      orgId: string;
      place: string;
      price: number;
      typeId: number;
      typeName: number;
    }>;
    region: string;
    regionName: string;
    scaleId: number;
    scaleName: number;
    testCenter: number;
    video: string;
    createTime: string;
  }[]
>;
//机构上传
export type insertOrgType = InterFunction<
  {
    auxiliaryPicture: string;
    description: string;
    detail: string;
    detailedAddress: string;
    latitude: number;
    longitude: number;
    mainImage: string;
    name: string;
    region: string;
    regionName: string;
    scaleId: number;
    testCenter: number;
    trainingProgramsVOS: Array<{
      gradeId: number;
      id: number;
      mainImage: string;
      modelsId: number;
      place: string;
      price: number;
      typeId: number;
    }>;
    video: string;
  },
  any
>;
//机构删除
export type removeOrgType = InterFunction<{ id: number }, any>;
//机构修改
export type updateOrgType = InterFunction<
  {
    auxiliaryPicture: string;
    description: string;
    detail: string;
    detailedAddress: string;
    latitude: number;
    longitude: number;
    mainImage: string;
    name: string;
    region: string;
    regionName: string;
    scaleId: number;
    testCenter: number;
    trainingProgramsVOS: Array<{
      gradeId: number;
      id: number;
      mainImage: string;
      modelsId: number;
      place: string;
      price: number;
      typeId: number;
    }>;
    video: string;
    id: number;
  },
  any
>;
// 所有课程分类列表
export type selectCurriculumClassifyType = InterFunction<
  NonNullable<unknown>,
  {
    classifyDesc: string;
    classifyUrl: string;
    createTime: string;
    id: number;
    name: string;
    oneCourseId: number;
    twoCourseId: number;
    updateTime: string;
  }[]
>;
// 新增课程分类
export type addCurriculumClassifyType = InterFunction<
  {
    classifyDesc?: string;
    classifyUrl?: string;
    createTime?: string;
    id?: number;
    name?: string;
    oneCourseId?: number;
    twoCourseId?: number;
    updateTime?: string;
  },
  NonNullable<unknown>
>;
// 删除课程分类
export type removeCurriculumClassifyType = InterFunction<
  {
    id: number;
  },
  NonNullable<unknown>
>;
