import { UploadFile } from 'antd/es/upload/interface';
// 商城-新增商品
import { InterFunction, InterItemFunction } from '~/api/interface';

//商品列表
export type listGoodsType = InterItemFunction<
  {
    directoryId?: number;
    goodsName?: string;
    goodsType: number;
    status?: number;
    startTime?: string;
    endTime?: string;
  },
  {
    createTime: string;
    directoryId: number;
    directoryName: string;
    goodsDesc: string;
    goodsName: string;
    imgUrl: string;
    isCoupons: number;
    status: number;
    id: number;
  }[]
>;
//商品-新增
export type BaseInfoType = {
  goodsName: string;
  goodsDesc: string;
  directoryId: number;
  tag: string;
  shelfStatus: number;
  categoryByOne: number;
  categoryByTwo: number;
  images: { id: number; imgType: number; imgUrl: string }[];
  goodsVideo: string;
};
// 库存规格
export interface specEntity {
  id: number;
  categoryId: number | string;
  goodsSpecName: string;
  skuId: number;
  specIds: any;
  chooseType: number;
  must: number;
  skuUnitId: number;
  customizeInfo?: customizeEntity[];
  productSpecList?: customizeEntity[];
  industrySpecList?: any;
  isCustomProd: boolean;
  skuName?: string;
  flag: number;
  productName?: string;
}
// 自定义规格
export interface customizeEntity {
  id: number;
  partNo: string;
  specName: string;
  specImage?: string;
  fileList?: UploadFile[];
  productSpecCPQVO?: any;
  productSpec?: number;
}
export type addGoodsType = InterFunction<
  BaseInfoType & {
    productSpec: specEntity[];
    goodsDetailVO: { goodsDesc: string; productDesc?: string };
    otherService: number[];
  },
  any
>;
//商品-编辑
export type editGoodsType = InterFunction<
  BaseInfoType & {
    productSpec: specEntity[];
    goodsDetailVO: { goodsDesc: string; productDesc?: string };
    otherService: number[];
    id: number;
  },
  any
>;
//商品-详情
export type detailGoodsType = InterFunction<
  { goodsInfoId: number; type: number; leaseTerm?: number },
  BaseInfoType & {
    goodsSpec: specEntity[];
    goodsDetail: { goodsDesc: string; productDesc: string; content: string };
    otherService: { id: number; saleServiceName: string; saleServiceId: number }[];
    goodsVideoId: number;
    id: number;
  }
>;
//商品-规格单位
export type skuUnitType = InterFunction<any, { id: number; unitName: string }[]>;
//商品-批量上下架
export type batchOnShelfOrTakeDownType = InterFunction<{ goodsIds: number[]; status: number }, any>;
//商品-单个上下架（新）
export type upOrDownShelfType = InterFunction<{ id: number; status: number }, any>;
//商品批量删除
export type batchRemoveWareInfoType = InterFunction<number[], any>;
//商品-单个删除
export type removeMallGoodsType = InterFunction<{ id: number }, any>;
//商品-上下移动
export type exchangeGoodsInfoType = InterFunction<{ firstId: number; secondId: number }, any>;

//商品-新增（新）
//商品item类型
type goodsItemType = {
  gambitId: number;
  categoryPrimaryId: number;
  categorySubId: number;
  description: string;
  goodsDetails: string;
  goodsLabel: string;
  goodsSpecList?: {
    chooseType: number;
    goodsSpecValuesList: {
      channelPrice?: number;
      id: any;
      partNo: string;
      salePrice: number;
      showPrice: number;
      specValueImage: string;
      specValueName: string;
      stock?: number;
      goodsSpecId?: number;
    }[];
    id: any;
    mallGoodsId: number;
    must: number;
    skuUnitId: number;
    specName: string;
  }[];
  curriculumIds: {
    id: number;
  }[];
  instructionsUrl: string;
  labelShow: number;
  resourcesList: {
    id: number;
    type: number;
    url: string;
  }[];
  shelfStatus: number;
  recommend: number;
  tradeName: string;
  priceStock: {
    channelPrice: number;
    id?: number;
    productSpec: string;
    salePrice: number;
    skuImage: string;
    skuNo: string;
    stock: number;
  }[];
  specAttrList: {
    specName: string;
    id: number;
    specValuesList: { specName: string; id: number }[];
  }[];
  priceShow: number;
};
export type addMallGoodsType = InterFunction<goodsItemType, any>;
//商品-编辑（新）
export type editMallGoodsType = InterFunction<goodsItemType & { id: number }, any>;
//商品-列表（新）
export type listPageGoodsInfoType = InterItemFunction<
  { categoryPrimaryId?: number; tradeName?: string; shelfStatus?: number; recommend?: number },
  (goodsItemType & { id: number })[]
>;
//商城-详情（新）
export type mallGoodsDetailsType = InterFunction<{ id: number }, goodsItemType & { id: number }>;
